% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/converters.R
\name{MaxQtoMSstatsPTMFormat}
\alias{MaxQtoMSstatsPTMFormat}
\title{Convert output of label-free or TMT MaxQuant experiments into MSstatsPTM format}
\usage{
MaxQtoMSstatsPTMFormat(
  evidence = NULL,
  annotation = NULL,
  fasta_path,
  fasta_protein_name = "uniprot_ac",
  mod_id = "\\\\(Phospho \\\\(STY\\\\)\\\\)",
  sites_data = NULL,
  evidence_prot = NULL,
  proteinGroups = NULL,
  annotation_protein = NULL,
  use_unmod_peptides = FALSE,
  labeling_type = "LF",
  mod_num = "Single",
  TMT_keyword = "TMT",
  ptm_keyword = "phos",
  which_proteinid_ptm = "Proteins",
  which_proteinid_protein = "Proteins",
  remove_other_mods = TRUE,
  removeMpeptides = FALSE,
  removeOxidationMpeptides = FALSE,
  removeProtein_with1Peptide = FALSE,
  use_log_file = TRUE,
  append = FALSE,
  verbose = TRUE,
  log_file_path = NULL
)
}
\arguments{
\item{evidence}{name of 'evidence.txt' data, which includes feature-level
data for enriched (PTM) data.}

\item{annotation}{data frame annotation file for the ptm level data.
Contains column Run, Fraction, TechRepMixture, Mixture, Channel,
BioReplicate, Condition.}

\item{fasta_path}{A string of path to a FASTA file, used to match PTM peptides.}

\item{fasta_protein_name}{Name of fasta column that matches with protein name
in evidence file. Default is \code{uniprot_ac}.}

\item{mod_id}{Character that indicates the modification of interest. Default
is \verb{\\\\(Phospho\\\\)}. Note \verb{\\\\} must be included before special characters.}

\item{sites_data}{(Not recommended. Only used if evidence file not provided.
Only works for TMT labeled data) Modified peptide output from MaxQuant. For
example, a phosphorylation experiment would require the Phospho(STY)Sites.txt
file}

\item{evidence_prot}{name of 'evidence.txt' data, which includes
feature-level data for global profiling (unmodified) data.}

\item{proteinGroups}{name of 'proteinGroups.txt' data. It needs to matching
protein group ID in \code{evidence_prot}.}

\item{annotation_protein}{data frame annotation file for the protein level data.
Contains column Run, Fraction, TechRepMixture, Mixture, Channel,
BioReplicate, Condition.}

\item{use_unmod_peptides}{Boolean if the unmodified peptides in the input
file should be used to construct the unmodified protein output. Only used if
\code{input_protein} is not provided. Default is \code{FALSE}.}

\item{labeling_type}{Either \code{TMT} or \code{LF} (Label-Free) depending on
experimental design. Default is \code{LF}.}

\item{mod_num}{(Only if \code{sites.data} is used) For modified peptide dataset.
The number modifications per peptide to be used. If "Single", only peptides
with one modification will be used. Otherwise "Total" can be selected which
does not cap the number of modifications per peptide. "Single" is the
default. Selecting "Total" may confound the effect of different
modifications.}

\item{TMT_keyword}{(Only if \code{sites.data} is used) the sub-name of columns
in sites.data file. Default is \code{TMT}. This corresponds to the columns in the
format \code{Reporter.intensity.corrected.1.TMT1phos___1}. Specifically, this
parameter indicates the first section of the string \code{TMT1phos} (Before the
mixture number). If \code{TMT} is present in the string, set this value to \code{TMT}.
Else if \code{TMT} is not there (ie string is in the format \verb{1phos}) leave this
parameter as an empty string ('').}

\item{ptm_keyword}{(Only if \code{sites.data} is used) the sub-name of columns in
the sites.data file. Default is
\code{phos}. This corresponds to the columns in the format
\code{Reporter.intensity.corrected.1.TMT1phos___1}. Specifically, this parameter
indicates the second section of the string \code{TMT1phos} (After the mixture
number). If the string is present, set this parameter. Else if this part of
the string is empty (ie string is in the format \code{TMT1}) leave this parameter
as an empty string ('').}

\item{which_proteinid_ptm}{For PTM dataset, which column to use for protein
name. Use 'Proteins'(default) column for protein name. 'Leading.proteins' or
'Leading.razor.protein' or 'Gene.names' can be used instead to get the
protein ID with single protein. However, those can potentially have the
shared peptides.}

\item{which_proteinid_protein}{For Protein dataset, which column to use for
protein name. Same options as above.}

\item{remove_other_mods}{Remove peptides which include modfications other
than the one listed in \code{mod_id}. Default is \code{TRUE}. For example, in an
experiment targeting Phosphorylation, setting this parameter to \code{TRUE} would
remove peptides like
(Acetyl (Protein N-term))AAAAPDSRVS(Phospho (STY))EEENLK. Set this parameter
to \code{FALSE} to keep peptides with extraneous modifications.}

\item{removeMpeptides}{If Oxidation (M) modifications should be removed.
Default is TRUE.}

\item{removeOxidationMpeptides}{TRUE will remove the peptides including
'oxidation (M)' in modification. FALSE is default.}

\item{removeProtein_with1Peptide}{TRUE will remove the proteins which have
only 1 peptide and charge. FALSE is default.}

\item{use_log_file}{logical. If TRUE, information about data processing will
be saved to a file.}

\item{append}{logical. If TRUE, information about data processing will be
added to an existing log file.}

\item{verbose}{logical. If TRUE, information about data processing wil be
printed to the console.}

\item{log_file_path}{character. Path to a file to which information about
data processing will be saved. If not provided, such a file will be created
automatically. If 'append = TRUE', has to be a valid path to a file.}
}
\value{
a list of two data.tables named 'PTM' and 'PROTEIN' in the format
required by MSstatsPTM.
}
\description{
Takes as input LF/TMT experiments from MaxQ and converts the data into the
format needed for MSstatsPTM. Requires modified evidence.txt file from MaxQ
and an annotation file for PTM data. To adjust modified peptides for changes
in global protein level, unmodified TMT experimental data must also be
returned. Optionally can use \verb{Phospho(STY)Sites.txt} (or other PTM specific
files) from MaxQuant, but this is not recommended. If PTM specific file
provided, the raw intensities must be provided, not a ratio.
}
\examples{
# TMT experiment
head(maxq_tmt_evidence)
head(maxq_tmt_annotation)

msstats_format_tmt = MaxQtoMSstatsPTMFormat(evidence=maxq_tmt_evidence,
                        annotation=maxq_tmt_annotation,
                        fasta=system.file("extdata", "maxq_tmt_fasta.fasta", package="MSstatsPTM"),
                        fasta_protein_name="uniprot_ac",
                        mod_id="\\\\(Phospho \\\\(STY\\\\)\\\\)",
                        use_unmod_peptides=TRUE,
                        labeling_type = "TMT",
                        which_proteinid_ptm = "Proteins")

head(msstats_format_tmt$PTM)
head(msstats_format_tmt$PROTEIN)

# LF experiment
head(maxq_lf_evidence)
head(maxq_lf_annotation)

msstats_format_lf = MaxQtoMSstatsPTMFormat(evidence=maxq_lf_evidence,
                        annotation=maxq_lf_annotation,
                        fasta=system.file("extdata", "maxq_lf_fasta.fasta", package="MSstatsPTM"),
                        fasta_protein_name="uniprot_ac",
                        mod_id="\\\\(Phospho \\\\(STY\\\\)\\\\)",
                        use_unmod_peptides=TRUE,
                        labeling_type = "LF",
                        which_proteinid_ptm = "Proteins")
head(msstats_format_lf$PTM)
head(msstats_format_lf$PROTEIN)
}
