% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/converters.R
\name{PDtoMSstatsPTMFormat}
\alias{PDtoMSstatsPTMFormat}
\title{Convert Proteome Discoverer output into MSstatsPTM format}
\usage{
PDtoMSstatsPTMFormat(
  input,
  annotation,
  fasta_path,
  protein_input = NULL,
  annotation_protein = NULL,
  labeling_type = "LF",
  mod_id = "\\\\(Phospho\\\\)",
  use_localization_cutoff = FALSE,
  keep_all_mods = FALSE,
  use_unmod_peptides = FALSE,
  fasta_protein_name = "uniprot_iso",
  localization_cutoff = 75,
  remove_unlocalized_peptides = TRUE,
  useNumProteinsColumn = FALSE,
  useUniquePeptide = TRUE,
  summaryforMultipleRows = max,
  removeFewMeasurements = TRUE,
  removeOxidationMpeptides = FALSE,
  removeProtein_with1Peptide = FALSE,
  which_quantification = "Precursor.Area",
  which_proteinid = "Protein.Group.Accessions",
  use_log_file = TRUE,
  append = FALSE,
  verbose = TRUE,
  log_file_path = NULL
)
}
\arguments{
\item{input}{PD report corresponding with enriched experimental data.}

\item{annotation}{name of 'annotation.txt' or 'annotation.csv' data which
includes Condition, BioReplicate, Run information. 'Run' will be matched
with 'Spectrum.File'}

\item{fasta_path}{string containing path to the corresponding fasta file for
the modified peptide dataset.}

\item{protein_input}{PD report corresponding with unmodified experimental
data.}

\item{annotation_protein}{Same format as \code{annotation} corresponding to
unmodified data.}

\item{labeling_type}{type of experimental design, must be one of \code{LF} for
label free or \code{TMT} for tandem mass tag.}

\item{mod_id}{Character that indicates the modification of interest. Default
is \verb{\\\\(Phospho\\\\)}. Note \verb{\\\\} must be included before special characters.}

\item{use_localization_cutoff}{Boolean indicating whether to use a custom
localization cutoff or rely on PD's modifications column. \code{TRUE} is default
and apply custom cutoff \code{localization_cutoff}.}

\item{keep_all_mods}{Boolean indicating whether to keep or remove peptides
not in \code{mod_id}. Default is FALSE.}

\item{use_unmod_peptides}{If \code{protein_input} is not provided,
unmodified peptides can be extracted from \code{input} to be used in place of a
global profiling run. Default is \code{FALSE}.}

\item{fasta_protein_name}{Name of fasta column that matches with protein name
in evidence file. Default is \code{uniprot_iso}.}

\item{localization_cutoff}{Minimum localization score required to keep modification. Default is .75.}

\item{remove_unlocalized_peptides}{Boolean indicating if peptides without all sites localized should be kept. Default is TRUE (non-localized sites will be removed).}

\item{useNumProteinsColumn}{TRUE removes peptides which have more than 1 in
Proteins column of PD output.}

\item{useUniquePeptide}{TRUE (default) removes peptides that are assigned
for more than one proteins. We assume to use unique peptide for each protein.}

\item{summaryforMultipleRows}{max(default) or sum - when there are multiple
measurements for certain feature and certain run, use highest or sum of
multiple intensities.}

\item{removeFewMeasurements}{TRUE (default) will remove the features that
have 1 or 2 measurements across runs.}

\item{removeOxidationMpeptides}{TRUE will remove the peptides including
'oxidation (M)' in modification. FALSE is default.}

\item{removeProtein_with1Peptide}{TRUE will remove the proteins which have
only 1 peptide and charge. FALSE is default.}

\item{which_quantification}{Use 'Precursor.Area'(default) column for
quantified intensities. 'Intensity' or 'Area' can be used instead.}

\item{which_proteinid}{Use 'Protein.Accessions'(default) column for protein
name. 'Master.Protein.Accessions' can be used instead.}

\item{use_log_file}{logical. If TRUE, information about data processing will
be saved to a file.}

\item{append}{logical. If TRUE, information about data processing will be
added to an existing log file.}

\item{verbose}{logical. If TRUE, information about data processing will be
printed to the console}

\item{log_file_path}{character. Path to a file to which information about
data processing will be saved. If not provided, such a file will be created
automatically. If 'append = TRUE', has to be a valid path to a file.}
}
\value{
\code{list} of \code{data.table}
}
\description{
Import Proteome Discoverer files, identify modification site location.
}
\examples{
head(pd_psm_input)
head(pd_annotation)

msstats_format = PDtoMSstatsPTMFormat(pd_psm_input, 
                                      pd_annotation, 
                                      system.file("extdata", "pd_fasta.fasta", package="MSstatsPTM"),
                                      use_unmod_peptides=TRUE, 
                                      which_proteinid = "Master.Protein.Accessions")

head(msstats_format$PTM)
head(msstats_format$PROTEIN)
}
