% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/converters.R
\name{ProgenesistoMSstatsPTMFormat}
\alias{ProgenesistoMSstatsPTMFormat}
\title{Converts non-TMT Progenesis output into the format needed for MSstatsPTM}
\usage{
ProgenesistoMSstatsPTMFormat(
  ptm_input,
  annotation,
  global_protein_input = FALSE,
  fasta_path = FALSE,
  useUniquePeptide = TRUE,
  summaryforMultipleRows = max,
  removeFewMeasurements = TRUE,
  removeOxidationMpeptides = FALSE,
  removeProtein_with1Peptide = FALSE,
  mod.num = "Single"
)
}
\arguments{
\item{ptm_input}{name of Progenesis output with modified peptides, which is
wide-format. 'Accession', Sequence', 'Modification', 'Charge' and one column
for each run are required}

\item{annotation}{name of 'annotation.txt' or 'annotation.csv' data which
includes Condition, BioReplicate, Run, and Type (PTM or Protein)
information. It will be matched with the column name of input for MS runs.
Please note PTM and global Protein run names are often different, which is
why an additional Type column indicating Protein or PTM is required.}

\item{global_protein_input}{name of Progenesis output with unmodified
peptides, which is wide-format. 'Accession', Sequence', 'Modification',
'Charge' and one column for each run are required}

\item{fasta_path}{string containing path to the corresponding fasta file for
the modified peptide dataset.}

\item{useUniquePeptide}{TRUE(default) removes peptides that are assigned for
more than one proteins. We assume to use unique peptide for each protein.}

\item{summaryforMultipleRows}{max(default) or sum - when there are multiple
measurements for certain feature and certain run, use highest or sum of
multiple intensities.}

\item{removeFewMeasurements}{TRUE (default) will remove the features that
have 1 or 2 measurements across runs.}

\item{removeOxidationMpeptides}{TRUE will remove the modified peptides
including 'Oxidation (M)' sequence. FALSE is default.}

\item{removeProtein_with1Peptide}{TRUE will remove the proteins which have
only 1 peptide and charge. FALSE is default.}

\item{mod.num}{For modified peptide dataset, must be one of \code{Single} or
\code{Total}. The default is \code{Single}. The number modifications per peptide to be
used. If "Single", only peptides with one modification will be
used. Otherwise "Total" includes peptides with more than one modification.
Selecting "Total" may confound the effect of different modifications.}
}
\value{
a list of two data.tables named 'PTM' and 'PROTEIN' in the format
required by MSstatsPTM.
}
\description{
Converts non-TMT Progenesis output into the format needed for MSstatsPTM
}
\examples{

# Example annotation file
annotation = data.frame('Condition' = c('Control', 'Control', 'Control',
                         'Treatment', 'Treatment', 'Treatment'),
                         'BioReplicate' = c(1,2,3,4,5,6),
                         'Run' = c('prot_run_1', 'prot_run_2', 'prot_run_3',
                                  'phos_run_1', 'phos_run_2', 'phos_run_3'),
                         'Type' = c("Protein", "Protein", "Protein", "PTM", 
                                    "PTM", "PTM"))
                                    
# The output should be in the following format.
head(raw.input$PTM)
head(raw.input$PROTEIN)
}
