% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/designSampleSizePTM.R
\name{designSampleSizePTM}
\alias{designSampleSizePTM}
\title{Planning future experimental designs of PTM experiments in sample size calculation}
\usage{
designSampleSizePTM(
  data,
  desiredFC,
  FDR = 0.05,
  numSample = TRUE,
  power = 0.8,
  use_log_file = TRUE,
  append = FALSE,
  verbose = TRUE,
  log_file_path = NULL,
  base = "MSstatsPTM_log_"
)
}
\arguments{
\item{data}{output of the groupComparisonPTM function.}

\item{desiredFC}{the range of a desired fold change which includes the lower
and upper values of the desired fold change.}

\item{FDR}{a pre-specified false discovery ratio (FDR) to control the overall
false positive rate. Default is 0.05}

\item{numSample}{minimal number of biological replicates per condition.
TRUE represents you require to calculate the sample size for this category,
else you should input the exact number of biological replicates.}

\item{power}{a pre-specified statistical power which defined as the probability
of detecting a true fold change. TRUE represent you require to calculate the power
for this category, else you should input the average of power you expect. Default is 0.9}

\item{use_log_file}{logical. If TRUE, information about data processing
will be saved to a file.}

\item{append}{logical. If TRUE, information about data processing will be
added to an existing log file.}

\item{verbose}{logical. If TRUE, information about data processing will be
printed to the console.}

\item{log_file_path}{character. Path to a file to which information about
data processing will be saved.
If not provided, such a file will be created automatically.
If \code{append = TRUE}, has to be a valid path to a file.}

\item{base}{start of the file name.}
}
\value{
data.frame - sample size calculation results including varibles:
desiredFC, numSample, FDR,  and power.
}
\description{
Calculate sample size for future experiments of a PTM
experiment based on intensity-based linear model. Calculation is only
available for group comparison experimental designs (not including time
series).
Two options of the calculation:
(1) number of biological replicates per condition,
(2) power.
}
\details{
The function fits the model and uses variance components to calculate
sample size. The underlying model fitting with intensity-based linear model with
technical MS run replication. Estimated sample size is rounded to 0 decimal.
The function can only obtain either one of the categories of the sample size
calculation (numSample, numPep, numTran, power) at the same time.
}
\examples{
model.lf.msstatsptm = groupComparisonPTM(summary.data, 
                                     data.type = "LabelFree",
                                     verbose = FALSE)
                                     
#(1) Minimal number of biological replicates per condition
designSampleSizePTM(data=model.lf.msstatsptm, numSample=TRUE,
                 desiredFC=c(2.0,2.75), FDR=0.05, power=0.8)
#(2) Power calculation
designSampleSizePTM(data=model.lf.msstatsptm, numSample=5,
                 desiredFC=c(2.0,2.75), FDR=0.05, power=TRUE)                                  


}
