% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/groupComparisonPTM.R
\name{groupComparisonPTM}
\alias{groupComparisonPTM}
\title{Perform differential analysis on MS-based proteomics experiments targeting PTMs}
\usage{
groupComparisonPTM(
  data,
  data.type,
  contrast.matrix = "pairwise",
  moderated = FALSE,
  adj.method = "BH",
  log_base = 2,
  use_log_file = TRUE,
  append = FALSE,
  verbose = TRUE,
  log_file_path = NULL,
  base = "MSstatsPTM_log_"
)
}
\arguments{
\item{data}{list of summarized datasets. Output of MSstatsPTM summarization
function \code{\link[MSstatsPTM]{dataSummarizationPTM}}  or
\code{\link[MSstatsPTM]{dataSummarizationPTM_TMT}} depending on acquisition
type.}

\item{data.type}{string indicating experimental acquisition type. "TMT" is
used for TMT labeled experiments. For all other experiments (Label Free/ DDA/
DIA) use "LabelFree".}

\item{contrast.matrix}{comparison between conditions of interests. Default
models full pairwise comparison between all conditions}

\item{moderated}{For TMT experiments only. TRUE will moderate t statistic;
FALSE (default) uses ordinary t statistic. Default is FALSE.}

\item{adj.method}{For TMT experiemnts only. Adjusted method for multiple
comparison. "BH" is default. "BH" is used for all other experiment types}

\item{log_base}{For non-TMT experiments only. The base of the logarithm used
in summarization.}

\item{use_log_file}{logical. If TRUE, information about data processing
will be saved to a file.}

\item{append}{logical. If TRUE, information about data processing will be
added to an existing log file.}

\item{verbose}{logical. If TRUE, information about data processing will be
printed to the console.}

\item{log_file_path}{character. Path to a file to which information about
data processing will be saved.
If not provided, such a file will be created automatically.
If \code{append = TRUE}, has to be a valid path to a file.}

\item{base}{start of the file name.}
}
\value{
list of modeling results. Includes PTM, PROTEIN, and ADJUSTED
data.tables with their corresponding model results.
}
\description{
Takes summarized PTM and protein data from \code{dataSummarizationPTM} or
\code{dataSummarizationPTM_TMT} functions and performs differential analysis.
Leverages unmodified protein data to perform adjustment and deconvolute the
effect of the PTM and unmodified protein. If protein data is unavailable,
PTM data can still be passed into the function, however adjustment can not be
performed. All model results are returned for completeness.
}
\examples{

model.lf.msstatsptm = groupComparisonPTM(summary.data, 
                                     data.type = "LabelFree",
                                     verbose = FALSE)
}
