% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataDoc.R
\docType{data}
\name{raw.input.tmt}
\alias{raw.input.tmt}
\title{Example of input PTM dataset for TMT experiments.}
\format{
A list of two data.tables named PTM and PROTEIN with 1716 and 29221
rows respectively.
}
\usage{
raw.input.tmt
}
\description{
It can be the output of MSstatsPTM converter MaxQtoMSstatsPTMFormat or other
MSstatsTMT converter functions (Please see MSstatsPTM_TMT_Workflow vignette).
The dataset is formatted as a list with two data.tables named PTM and
PROTEIN. In each data.table the variables are as follows:
}
\details{
\itemize{
\item ProteinName : Name of protein with modification site mapped in with
an underscore. ie "Protein_4_Y474"
\item PeptideSequence
\item Charge
\item PSM
\item Mixture : Mixture of samples labeled with different TMT reagents,
which can be analyzed in
a single mass spectrometry experiment. If the channal doesn't have sample,
please add \verb{Empty' under Condition. \\item TechRepMixture : Technical replicate of one mixture. One mixture may have multiple technical replicates. For example, if }TechRepMixture' = 1, 2 are the two technical replicates of
one mixture, then they should match
with same \verb{Mixture' value. \\item Run : MS run ID. \\item Channel : Labeling information (126, ... 131). \\item Condition : Condition (ex. Healthy, Cancer, Time0) \\item BioReplicate : Unique ID for biological subject. If the channal doesn't have sample, please add }Empty' under BioReplicate.
\item Intensity
}
}
\examples{
head(raw.input.tmt$PTM)
head(raw.input.tmt$PROTEIN)

}
\keyword{datasets}
