% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ViewRef.R
\name{View-Reference-methods}
\alias{View-Reference-methods}
\alias{viewASE}
\alias{viewIR}
\alias{viewIntrons}
\alias{viewIR_NMD}
\alias{viewExons}
\alias{viewGenes}
\alias{viewGO}
\alias{viewProteins}
\alias{viewTranscripts}
\title{View SpliceWiz Reference in read-able data frames}
\usage{
viewASE(reference_path)

viewIR(reference_path, directional = TRUE)

viewIntrons(reference_path)

viewIR_NMD(reference_path)

viewExons(reference_path)

viewGenes(reference_path)

viewGO(reference_path)

viewProteins(reference_path)

viewTranscripts(reference_path)
}
\arguments{
\item{reference_path}{The directory containing the SpliceWiz reference}

\item{directional}{(default \code{TRUE}) Whether to view IR events for stranded
RNAseq \code{TRUE} or unstranded protocol \code{FALSE}}
}
\value{
A data frame containing the relevant info. See details
}
\description{
These functions allow users to construct tables containing SpliceWiz's
reference of alternate splicing events, intron retention events, and
other relevant data
}
\section{Functions}{
\itemize{
\item \code{viewASE()}: Outputs summary of alternative splicing
events constructed by SpliceWiz

\item \code{viewIR()}: Outputs summary of assessed IRFinde-like
IR events, constructed by SpliceWiz

\item \code{viewIntrons()}: Outputs summary of all introns from
the annotation, constructed by SpliceWiz

\item \code{viewIR_NMD()}: Outputs information for every intron -
whether retention of the intron will convert the transcript to an NMD
substrate

\item \code{viewExons()}: Outputs information for every exon
from the annotation.

\item \code{viewGenes()}: Outputs information for every gene
from the annotation.

\item \code{viewGO()}: Outputs information for every gene
from the annotation.

\item \code{viewProteins()}: Outputs information for every
protein-coding exon from the annotation.

\item \code{viewTranscripts()}: Outputs information for every
transcript from the annotation.

}}
\examples{
ref_path <- file.path(tempdir(), "Reference_withGO")
buildRef(
    reference_path = ref_path,
    fasta = chrZ_genome(),
    gtf = chrZ_gtf(),
    ontologySpecies = "Homo sapiens"
)

df <- viewASE(ref_path)

df <- viewIR(ref_path, directional = TRUE)

df <- viewIntrons(ref_path)

df <- viewIR_NMD(ref_path)

df <- viewExons(ref_path)

df <- viewGenes(ref_path)

df <- viewProteins(ref_path)

df <- viewTranscripts(ref_path)

df <- viewGO(ref_path)

}
\seealso{
\link{Build-Reference-methods}
}
