% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{coord2GR}
\alias{coord2GR}
\title{Converts genomic coordinates into a GRanges object}
\usage{
coord2GR(coordinates)
}
\arguments{
\item{coordinates}{A string vector of one or more genomic coordinates
to be converted}
}
\value{
A GRanges object that corresponds to the given coordinates
}
\description{
This function takes a string vector of genomic coordinates and converts it
into a GRanges object.
}
\details{
Genomic coordinates can take one of the following syntax:
\itemize{
\item \code{seqnames:start}
\item \code{seqnames:start-end}
\item \code{seqnames:start-end/strand}
}

The following examples are considered valid genomic coordinates:
\itemize{
\item "chr1:21535"
\item "chr3:10550-10730"
\item "X:51231-51330/-"
\item "chrM:2134-5232/+"
}
}
\examples{
se <- SpliceWiz_example_NxtSE()

coordinates <- rowData(se)$EventRegion

gr <- coord2GR(coordinates)
}
