% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covPlotObject-methods.R
\name{covPlotObject-class}
\alias{covPlotObject-class}
\alias{tracks}
\alias{tracks,covPlotObject-method}
\alias{condition}
\alias{condition,covPlotObject-method}
\alias{getPlotObject}
\alias{plotView}
\title{Versatile coverage plots for SpliceWiz}
\usage{
getPlotObject(object, Event, strand = c("*", "+", "-"), tracks, condition, ...)

\S4method{tracks}{covPlotObject}(object)

\S4method{condition}{covPlotObject}(object)

plotView(
  object,
  view_start,
  view_end,
  oldP = covPlotly(),
  centerByEvent = FALSE,
  EventZoomFactor = 0.2,
  EventBasesFlanking = 100,
  resolution = 5000,
  trackList = list(),
  diff_stat = c("t-test", "none"),
  diffList = list(),
  reverseGenomeCoords = FALSE,
  ribbon_mode = c("sd", "sem", "ci", "none"),
  normalizeCoverage = FALSE,
  plotAnnotations = TRUE,
  plotAnnoSubTrack = TRUE,
  showExonRanges = FALSE,
  verticalLayout = c(4, 1, 1, 2),
  horizontalLayout = c(),
  filterByTranscripts = "",
  filterByEventTranscripts = FALSE,
  filterByExpressedTranscripts = TRUE,
  condenseTranscripts = FALSE,
  plotJunctions = TRUE,
  plotJuncPSI = FALSE,
  junctionThreshold = 0.01,
  plotRanges = GRanges(),
  rangesBasesFlanking = 100,
  usePlotly = FALSE,
  ...
)
}
\arguments{
\item{object}{For \code{getPlotObject()}, a \code{covDataObject} created using
\code{getCoverageData}. For \code{plotView()}, a \code{covPlotObject} created using
\code{getPlotObject()}.}

\item{Event}{The EventName of the alternative splicing event
which will be highlighted and used for normalization}

\item{strand}{The strand for coverage / junction plotting. Options are \code{"+"},
\code{"-"}, or \code{"*"} (unstranded - default)}

\item{tracks}{Sample names or condition categories}

\item{condition}{For condition-based group plots, the name of the condition.}

\item{...}{Ignored / not used}

\item{view_start, view_end}{The start and end coordinates for plotting}

\item{oldP}{(Optional) If plotting the same tracks and track-widths,
supplying the old \code{covPlotly} object (returned from a previous call to
\code{plotView()}) results in faster run-time (as plotly::subplot is a time-
consuming function)}

\item{centerByEvent}{(default \code{FALSE}) If true, centers the view to the
specified \code{Event}}

\item{EventZoomFactor}{If \code{centerByEvent = TRUE}, the zoom-out factor to plot
the view. Zooms out in exponents of 3
(i.e., zoom of 1 means 3x, 2 means 9x, and 0 means 1x)}

\item{EventBasesFlanking}{(default \code{100})
If \code{centerByEvent = TRUE}, includes how many bases flanking the event.}

\item{resolution}{The number of horizontal "pixels" or data-points to plot.
This is calculated per sub-plot. Smaller numbers lead to lower resolution
but faster plots. Default is \code{5000}}

\item{trackList}{A list, with each element being a vector of 1 or more track
names or indices to plot. If a vector is supplied it will be coerced to a
list}

\item{diff_stat}{(default "t-test") Which statistical method to perform
differential comparisons.}

\item{diffList}{A list, with each element being a vector of size 2,
containing names or indices of which tracks to contrast.}

\item{reverseGenomeCoords}{If \code{TRUE}, the genomic coordinate axis will be
reversed to plot negative stranded genes}

\item{ribbon_mode}{The statistic to represent variance. Options are "sd" -
standard deviation, "sem" - standard error of the mean, "ci" -
95\% confidence interval, or "none"}

\item{normalizeCoverage}{If \code{TRUE}, coverages and junctions of individual
samples will be normalized by the given \code{Event}.}

\item{plotAnnotations}{Whether the main annotation track should be plotted}

\item{plotAnnoSubTrack}{If plotting by exon ranges (using \code{plotRanges}),
whether a separate sub-track showing zoomed-in exons should be shown
above the main annotation track (and below the coverage plots)}

\item{showExonRanges}{(only applies if \code{usePlotly = FALSE}) Whether the
main annotation track should be replaced by labeled exon names. If \code{TRUE}
the returned value of \code{plotView()} is a named GRanges object containing
the exon ranges}

\item{verticalLayout}{A vector (of length 4) containing relative heights of
the following elements: (1) main block of coverage tracks, (2) differential
track, (3) annotation sub-track, and (4) main annotation track. Default
\code{c(4,1,1,2)}}

\item{horizontalLayout}{A vector containing relative widths of coverage
tracks. Only used alongside \code{plotRanges} with more than 1 range to plot.
If omitted, \code{plotView} will attempt to scale widths to the widths of the
exon ranges.}

\item{filterByTranscripts}{(default \code{""}) One or more named transcripts to
filter the annotation track.}

\item{filterByEventTranscripts}{(default \code{FALSE}) If \code{TRUE}, only transcripts
involved in the given \code{Event} will be plotted, if any}

\item{filterByExpressedTranscripts}{(default \code{TRUE}) Only transcripts with
supported junctions will be plotted on the annotation axis. An expressed
junction is that which contains more than the minimum \code{junctionThreshold}
in at least 1 track}

\item{condenseTranscripts}{Whether to plot by genes \code{TRUE} or transcripts
\code{FALSE}}

\item{plotJunctions}{Whether to plot junction counts as numbered arcs. Plots
normalized junctions if \code{normalizeCoverage = TRUE}.}

\item{plotJuncPSI}{If plotting group coverage plots, whether to plot
mean +/- sd of normalized junction counts \code{FALSE}, or estimated junction
PSI based on SpliceOver metric applied to each junction \code{TRUE}.}

\item{junctionThreshold}{(default \code{0.01}) Junctions with expressions below
this threshold will not be plotted. For raw counts, this is a fraction of
maximum coverage value of the track.}

\item{plotRanges}{A GRanges object containing one or more exon ranges to
plot. If given, \code{view_start} and \code{view_end} will be ignored. Typical use
is to use the output of the \code{plotView(..., usePlotly = FALSE)}, which
returns a named GRanges object, then subset this output by exon name.}

\item{rangesBasesFlanking}{(default \code{100}) How many flanking bases to add to
each of \code{plotRanges}. Ignored if only 1 range given (or using
\code{view_start} and \code{view_end})}

\item{usePlotly}{If \code{TRUE}, returns a \code{covPlotly} object containing the
plotly-based interactive plot. If \code{FALSE}, returns a ggplot object.}
}
\value{
For \code{getPlotObject()}: A \code{covPlotObject} object containing Event-based
data to create coverage plots using \code{plotView()}.

For \code{plotView()}:
\itemize{
\item If \code{usePlotly = TRUE}, returns a \code{covPlotly} object containing plotly-based
interactive plot
\item If \code{usePlotly = FALSE}, returns a patchwork-assembled static plot, unless
\code{showExonRanges = TRUE} in which it shows the plot and returns a named
GRanges object containing exon ranges.
}
}
\description{
Here, we implement fast and versatile ggplot and plotly based
coverage and sashimi plots. Users can plot with unlimited number
of individual, individual-normalized, or group-normalized tracks.
Also implemented is user-defined group-comparison differential plots
(including t-test plots). Additionally, users can generate ggplots
subsetted by exon groups. See details below.
}
\details{
The typical pipeline for plotting versatile coverage plots is as follows:
\itemize{
\item A \code{covDataObject} is generated by calling \code{getCoverageData()} using an
input \code{NxtSE} object. This step retrieves coverage, junction counts and
normalization data for the relevant genomic region being queried. A new
\code{covDataObject} is necessary when querying a new genomic region.
\item A \code{covPlotObject} is generated by calling \code{getPlotObject()} using an
input \code{covDataObject}. This step retrieves alternative splicing event
specific data, such as normalized coverages, or group combined coverages.
A new \code{covPlotObject} is required when changing \code{condition}, \code{Event},
\code{strand}, or when querying using a different set of \code{tracks}.
\item Plots can be generated by calling \code{plotView()} using a \code{covPlotObject}.
Interactive plotly plots can be generated by setting \code{usePlotly = TRUE},
otherwise, static plots are generated. For interactive plots, a \code{covPlotly}
object is returned, which contains raw data which is downsampled by
pixel resolution prior to plotting for performance reasons. A new
\code{covPlotly} is required unless one only wishes to downsample the resolution
\itemize{
\item see \link{setResolution} for \code{covPlotly} objects.
}
}

Tracks are now versatile (unlimited). Samples are retrieved by individual
sample names at \code{getCoverageData()}. If \code{condition} is set in
\code{getPlotObject()}, track names are defined by their condition categorical
names; otherwise, tracks are named by individual samples when retrieved using
\code{getPlotObject()}.
\itemize{
\item When calling \code{plotView()}, \code{trackList} by default displays all tracks as
ordered in the \code{covPlotObject}. Users can supply a vector containing either
the track names (or numbers, as ordered in the \code{covPlotObject}).
Alternatively, multiple traces can be stacked in a single track by
using a list, e.g. \code{trackList = list(A = c(1,2,3), B = c(4,5,6))}.
\item For differential comparisons, \code{diffList} takes a list of pairs of samples.
For example, if \code{trackList = list("A", "B")}, then setting
\code{diffList = list(c("A", "B"))} will compare groups "A" and "B". This is only
activated by setting \code{diff_stat} to anything other than \code{none}. For now,
only \code{t-test} is supported.
}

\code{plotView()} supports plotting by exon ranges, for which only static plots
are currently supported. The workflow for generating such a plot is as
follows:
\itemize{
\item A GRanges object is returned by the \code{plotView()} function and setting
\code{showExonRanges = TRUE}. \code{plotView()} will simultaneously show an
annotation plot of exons labelled by their "exon names", which is the
transcript name appended with "-E" followed by the exon number.
\item If \code{plotView()} is called and \code{usePlotly = TRUE} is set, a \code{covPlotly}
object is returned. Calling \code{showExons()} on this object will display
a plotly plot showing exon names, and returning a GRanges object of exon
ranges.
\item Exon ranges can be supplied to the \code{plotView()} function  by setting
the \code{plotRanges} parameter as a GRanges object. This will generate a static
plot showing coverage plots segmented by exons.
}
}
\section{Functions}{
\itemize{
\item \code{getPlotObject()}: Generates a covPlotObject object from a
covDataObject. Allows users to change parameters such as viewing window,
conditions, tracks, and other parameters, for customizing plot parameters

\item \code{tracks(covPlotObject)}: Returns the tracks contained in the
covPlotObject object

\item \code{condition(covPlotObject)}: Returns the condition value set in the
covPlotObject object

\item \code{plotView()}: Creates a coverage plot using the stored
data in the covPlotObject

}}
\examples{
se <- SpliceWiz_example_NxtSE(novelSplicing = TRUE)

# Assign annotation of the experimental conditions
colData(se)$treatment <- rep(c("A", "B"), each = 3)

# Retrieve coverage data for all samples for the gene "SRSF3" (and surrounds)

dataObj <- getCoverageData(
    se,
    Gene = "SRSF3",
    tracks = colnames(se)
)

# Retrieves raw / normalized coverage / junction data for the 
# specified SRSF3 skipped exon event:

plotObj_samples <- getPlotObject(
    dataObj,
    Event = "SE:SRSF3-203-exon4;SRSF3-202-int3"
)

# Retrieves data for samples grouped by the specified condition

plotObj_group <- getPlotObject(
    dataObj,
    Event = "SE:SRSF3-203-exon4;SRSF3-202-int3",
    condition = "treatment",
    tracks = c("A", "B")
)

# Display tracks and conditions of covPlotObject

tracks(plotObj_group)
condition(plotObj_group)

# Show static ggplots

plotView(plotObj_samples)

plotView(plotObj_group, centerByEvent = TRUE)

# Plot junctions using PSI estimates based on individual junction SpliceOver
# metrics

plotView(plotObj_group, centerByEvent = TRUE, plotJuncPSI = TRUE)


# Show normalized coverages, individual samples stacked in grouped tracks

plotView(
    plotObj_samples, 
    normalizeCoverage = TRUE, 
    trackList = list(A = c(1,2,3), B = c(4,5,6))
)

# Show stacked group comparisons with t-test

plotView(
    plotObj_group, 
    trackList = list(c(1,2)),
    diffList = list(c("A", "B")),
    diff_stat = "t-test"
)

# Show interactive plotly:

if(interactive()) {
    p <- plotView(plotObj_samples, usePlotly = TRUE)
    show(p)
}

# Show exons with coverage plot

# static:
gr <- plotView(plotObj_samples, showExonRanges = TRUE)

# interactive:
if(interactive()) {
    p <- plotView(plotObj_samples, usePlotly = TRUE)
    gr <- showExons(p)
}

# Plot coverage by exons

p <- plotView(plotObj_samples, 
    plotRanges = gr[c("SRSF3-203-E3", "SRSF3-203-E4", "SRSF3-203-E5")],
    horizontalLayout = c(1,1,1)
)

}
\seealso{
\link{getCoverageData} \linkS4class{covPlotly}
}
