% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot_themes.R
\docType{data}
\name{theme_white}
\alias{theme_white}
\alias{theme_white_legend}
\alias{theme_white_legend_plot_track}
\title{ggplot2 themes}
\format{
An object of class \code{theme} (inherits from \code{gg}) of length 10.

An object of class \code{theme} (inherits from \code{gg}) of length 9.

An object of class \code{theme} (inherits from \code{gg}) of length 10.
}
\usage{
theme_white

theme_white_legend

theme_white_legend_plot_track
}
\description{
A ggplot theme object for white background figures +/- a legend
}
\section{Functions}{
\itemize{
\item \code{theme_white}: White theme without figure legend

\item \code{theme_white_legend}: White theme but with a figure legend (if applicable)

\item \code{theme_white_legend_plot_track}: White theme with figure legend but without horizontal
grid lines. Used internally in PlotGenome

}}
\examples{
library(ggplot2)
df <- data.frame(
  gp = factor(rep(letters[1:3], each = 10)),
  y = rnorm(30))
ggplot(df, aes(gp, y)) +
  geom_point() +
  theme_white
}
\seealso{
\link{plotCoverage}
}
\keyword{datasets}
