% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/localVariance.R
\name{localVariance}
\alias{localVariance}
\title{localVariance Function}
\usage{
localVariance(
  spe,
  n_neighbors = 36,
  metric = c("expr_chrM_ratio"),
  samples = "sample_id",
  log = FALSE,
  name = NULL
)
}
\arguments{
\item{spe}{SpatialExperiment object with the following columns in colData:
sample_id, sum_umi, sum_gene}

\item{n_neighbors}{Number of nearest neighbors to use for variance
calculation}

\item{metric}{metric to use for variance calculation}

\item{samples}{Column in colData to use for sample ID}

\item{log}{Whether to log1p transform the metric}

\item{name}{Name of the new column to add to colData}
}
\value{
SpatialExperiment object with metric variance added to colData
}
\description{
This function does calculates the local variance based on kNN.
}
\examples{

# for more details see extended example in vignettes
library(SpotSweeper)
library(SpatialExperiment)
library(escheR)

# load example data
spe <- STexampleData::Visium_humanDLPFC()

# change from gene id to gene names
rownames(spe) <- rowData(spe)$gene_name

# show column data before SpotSweepR
colnames(colData(spe))

# drop out-of-tissue spots
spe <- spe[, spe$in_tissue == 1]
spe <- spe[, !is.na(spe$ground_truth)]

# Identifying the mitochondrial transcripts in our SpatialExperiment.
is.mito <- rownames(spe)[grepl("^MT-", rownames(spe))]

# Calculating QC metric for each spot using scuttle
spe <- scuttle::addPerCellQCMetrics(spe, subsets = list(Mito = is.mito))
colnames(colData(spe))

spe <- localVariance(spe,
    metric = "subsets_Mito_percent",
    n_neighbors = 36,
    name = "local_mito_variance_k36"
    )

plotQC(spe, metric="local_mito_variance_k36")

}
