% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_duplicate_classification.R
\name{get_transposed_classes}
\alias{get_transposed_classes}
\title{Classify TRD genes as derived from either DNA transposons or retrotransposons}
\usage{
get_transposed_classes(pairs, intron_counts)
}
\arguments{
\item{pairs}{A 3-column data frame with columns \strong{dup1}, \strong{dup2},
and \strong{type} indicating duplicated gene 1, duplicated gene 2, and
the mode of duplication associated with the pair. This data frame
is returned by \code{get_transposed()}.}

\item{intron_counts}{A 2-column data frame with columns \strong{gene}
and \strong{introns} indicating the number of introns for each gene,
as returned by \code{get_intron_counts}.}
}
\value{
A 3-column data frame with the following variables:
\describe{
\item{dup1}{Character, duplicated gene 1.}
\item{dup2}{Character, duplicated gene 2.}
\item{type}{Factor of duplication types, with levels
"SD" (segmental duplication),
"TD" (tandem duplication),
"PD" (proximal duplication),
"dTRD" (DNA transposon-derived duplication),
"rTRD" (retrotransposon-derived duplication), and
"DD" (dispersed duplication).}
}
}
\description{
Classify TRD genes as derived from either DNA transposons or retrotransposons
}
\examples{
data(diamond_inter)
data(diamond_intra)
data(yeast_seq)
data(yeast_annot)
data(fungi_kaks)
scerevisiae_kaks <- fungi_kaks$saccharomyces_cerevisiae

# Get processed annotation
pdata <- syntenet::process_input(yeast_seq, yeast_annot)
annotation <- pdata$annotation

# Get duplicated pairs
pairs <- scerevisiae_kaks[, c("dup1", "dup2", "type")]
pairs$dup1 <- paste0("Sce_", pairs$dup1)
pairs$dup2 <- paste0("Sce_", pairs$dup2)

# Classify pairs
trd <- get_transposed(pairs, diamond_inter, annotation)

# Create TxDb object from GRanges
library(txdbmaker)
txdb <- txdbmaker::makeTxDbFromGRanges(yeast_annot[[1]])

# Get intron counts
intron_counts <- get_intron_counts(txdb)

# Get TRD classes
trd_classes <- get_transposed_classes(trd, intron_counts)

}
