% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{plot_duplicate_freqs}
\alias{plot_duplicate_freqs}
\title{Plot frequency of duplicates per mode for each species}
\usage{
plot_duplicate_freqs(dup_counts, plot_type = "facet", remove_zero = TRUE)
}
\arguments{
\item{dup_counts}{A data frame in long format with the number of
duplicates per mode for each species, as returned by
the function \code{duplicates2counts}.}

\item{plot_type}{Character indicating how to plot frequencies. One of
'facet' (facets for each level of the variable \strong{type}),
'stack' (levels of the variable \strong{type} as stacked bars), or
'stack_percent' (levels of the variable \strong{type} as stacked bars,
with x-axis representing relative frequencies). Default: 'facet'.}

\item{remove_zero}{Logical indicating whether or not to remove rows
with zero values. Default: TRUE.}
}
\value{
A ggplot object.
}
\description{
Plot frequency of duplicates per mode for each species
}
\examples{
data(fungi_kaks)

# Get unique duplicates
duplicate_list <- classify_genes(fungi_kaks)

# Get count table
dup_counts <- duplicates2counts(duplicate_list)

# Plot counts
plot_duplicate_freqs(dup_counts, plot_type = "stack_percent")
}
