% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ka_ks_analyses.R
\name{split_pairs_by_peak}
\alias{split_pairs_by_peak}
\title{Split gene pairs based on their Ks peaks}
\usage{
split_pairs_by_peak(ks_df, peaks, nsd = 2, binwidth = 0.05)
}
\arguments{
\item{ks_df}{A 3-column data frame with gene pairs in columns 1 and 2,
and Ks values for the gene pair in column 3.}

\item{peaks}{A list with mean, standard deviation, and amplitude of Ks
peaks as generated by \code{find_ks_peaks}.}

\item{nsd}{Numeric with the number of standard deviations to consider
for each peak.}

\item{binwidth}{Numeric scalar with binwidth for the histogram.
Default: 0.05.}
}
\value{
A list with the following elements:
\describe{
\item{pairs}{A 4-column data frame with the variables
\strong{dup1} (character), \strong{dup2} (character),
\strong{ks} (numeric), and \strong{peak} (numeric),
representing duplicate gene pair, Ks values, and peak ID,
respectively.}
\item{plot}{A ggplot object with Ks peaks as returned by
\code{plot_ks_peaks}, but with dashed red lines indicating
boundaries for each peak.}
}
}
\description{
The purpose of this function is to classify gene pairs by age when there
are 2+ Ks peaks. This way, newer gene pairs are found within a
certain number of standard deviations from the highest peak,
and older genes are found close within smaller peaks.
}
\examples{
data(fungi_kaks)
scerevisiae_kaks <- fungi_kaks$saccharomyces_cerevisiae

# Create a data frame of duplicate pairs and Ks values
ks_df <- scerevisiae_kaks[, c("dup1", "dup2", "Ks")]

# Create list of peaks
peaks <- find_ks_peaks(ks_df$Ks, npeaks = 2)

# Split pairs
spairs <- split_pairs_by_peak(ks_df, peaks) 
}
