% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{cytobands}
\alias{cytobands}
\alias{grch37.cytobands}
\alias{grch38.cytobands}
\title{Cytogenetic bands}
\format{
Cytogenetic bands for standard chromosomes from GRCh37,in the format
required by \link[Gviz]{IdeogramTrack}. A data.frame with 5 columns:
\describe{
\item{chrom}{Chromosome}
\item{chromStart}{Starting position for each cytogenetic band}
\item{chromEnd}{End position for each cytogenetic band}
\item{name}{Name for each band, e.g. p.36.33}
\item{gieStain}{Staining pattern}
}

An object of class \code{data.frame} with 862 rows and 5 columns.
}
\source{
\url{https://hgdownload.soe.ucsc.edu/goldenPath/hg19/database/cytoBand.txt.gz}

\url{https://hgdownload.soe.ucsc.edu/goldenPath/hg38/database/cytoBand.txt.gz}
}
\usage{
data(grch37.cytobands)

data(grch38.cytobands)
}
\description{
Cytogenetic bands for GRCh37/hg19 and GRCh38/hg38
}
\examples{
data(grch37.cytobands)
head(grch37.cytobands)

data(grch38.cytobands)
head(grch38.cytobands)

}
\keyword{datasets}
