% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotAssayDensities.R
\name{plotAssayDensities}
\alias{plotAssayDensities}
\alias{plotAssayDensities,SummarizedExperiment-method}
\title{Plot Densities for any assay within a SummarizedExperiment}
\usage{
plotAssayDensities(x, ...)

\S4method{plotAssayDensities}{SummarizedExperiment}(
  x,
  assay = "counts",
  colour,
  linetype,
  group,
  trans = NULL,
  n_max = Inf,
  ...
)
}
\arguments{
\item{x}{A SummarizedExperiment object}

\item{...}{Passed to \link[stats]{density}}

\item{assay}{An assay within x}

\item{colour}{Optional column in colData to colour lines by. To remove any
colours, set this argument to \code{NULL}}

\item{linetype}{Any optional column in colData used to determine linetype}

\item{group}{Used by \link[ggplot2]{geom_line}. Defaults to the sample names
but setting to NULL will over-write this and only groups specified by colour
or linetype will be drawn}

\item{trans}{character(1). Any transformative function to be applied to the
data before calculating the density, e.g. \code{trans = "log2"}}

\item{n_max}{Maximum number of points to use when calculating densities}
}
\value{
A \code{ggplot2} object. Scales and labels can be added using conventional
\code{ggplot2} syntax.
}
\description{
Plot Densities for any assay within a SummarizedExperiment
}
\details{
Uses ggplot2 to create a density plot for all samples within the selected
assay
}
\examples{
data("se")
se$treatment <- c("E2", "E2", "E2", "E2DHT", "E2DHT", "E2DHT")
## Plot individual samples
plotAssayDensities(se, colour = "treatment")
## Plot combined within treatment groups
plotAssayDensities(se, colour = "treatment", group = "treatment")
## Use a data transformation
plotAssayDensities(se, trans = "log1p", colour = "treat")

}
