% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotAssayPCA.R
\name{plotAssayPCA}
\alias{plotAssayPCA}
\alias{plotAssayPCA,SummarizedExperiment-method}
\title{Plot PCA For any assay within a SummarizedExperiment}
\usage{
plotAssayPCA(x, ...)

\S4method{plotAssayPCA}{SummarizedExperiment}(
  x,
  assay = "counts",
  colour,
  shape,
  size,
  label,
  show_points = TRUE,
  pc_x = 1,
  pc_y = 2,
  trans = NULL,
  n_max = Inf,
  tol = sqrt(.Machine$double.eps),
  rank = NULL,
  ...
)
}
\arguments{
\item{x}{An object containing an assay slot}

\item{...}{Passed to \link[ggplot2]{geom_text}}

\item{assay}{The assay to perform PCA on}

\item{colour}{The column name to be used for colours}

\item{shape, size}{The column name(s) to be used for determining the shape
or size of points}

\item{label}{The column name to be used for labels}

\item{show_points}{logical(1). Display the points. If \code{TRUE} any labels will
repel. If \code{FALSE}, labels will appear at the exact points}

\item{pc_x}{numeric(1) The PC to plot on the x-axis}

\item{pc_y}{numeric(1) The PC to plot on the y-axis}

\item{trans}{character(1). Any transformative function to be applied to the
data before performing the PCA, e.g. \code{trans = "log2"}}

\item{n_max}{Subsample the data to this many points before performing PCA}

\item{tol}{Any rows with variance below this value will be excluded prior to
passing to \link[stats]{prcomp}. All rows are scaled and centred by default}

\item{rank}{Passed to \link[stats]{prcomp}}
}
\value{
A ggplot2 object
}
\description{
Plot PCA for any assay within a SummarizedExperiment object
}
\details{
Uses ggplot2 to create a PCA plot for the selected assay. Any numerical
transformation prior to performing the PCA can be specified using the
\code{trans} argument
}
\examples{
data("se")
se$treatment <- c("E2", "E2", "E2", "E2DHT", "E2DHT", "E2DHT")
se$sample <- colnames(se)
plotAssayPCA(se, trans = "log1p", colour = "treatment", label = "sample")
plotAssayPCA(
  se, trans = "log1p", colour = "treatment", label = "sample",
  size = totals / 1e3
)
plotAssayPCA(
  se, trans = "log1p", colour = "treatment", label = "sample",
  show_points = FALSE
)


}
