% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotHFGC.R
\name{plotHFGC}
\alias{plotHFGC}
\title{Plot a Genomic Region showing HiC, Features, Genes and Coverage}
\usage{
plotHFGC(
  gr,
  hic,
  features,
  genes,
  coverage,
  annotation,
  zoom = 1,
  shift = 0,
  max = 1e+07,
  axistrack = TRUE,
  cytobands,
  covtype = c("l", "heatmap"),
  linecol = c(),
  gradient = hcl.colors(101, "viridis"),
  hiccol = list(anchors = "lightblue", interactions = "red"),
  featcol,
  genecol,
  annotcol,
  highlight = "blue",
  hicsize = 1,
  featsize = 1,
  genesize = 1,
  covsize = 4,
  annotsize = 0.5,
  hicname = "HiC",
  featname = "Features",
  featstack = c("full", "hide", "dense", "squish", "pack"),
  collapseTranscripts = "auto",
  maxTrans = 12,
  ylim = NULL,
  ...,
  fontsize = 12,
  cex.title = 0.8,
  rotation.title = 0,
  col.title = "white",
  background.title = "lightgray",
  title.width = 1.5
)
}
\arguments{
\item{gr}{The range(s) of interest. Must be on a single chromosome}

\item{hic}{Any HiC interactions to be included as a GenomicInteractions
object. If not supplied, no HiC track will be drawn.}

\item{features}{A named GRangesList or list of GRangesList objects. Each
GRangesList should contain features in each element which will drawn on the
same track. If providing a list, each GRangesList within the list will drawn
on a separate track. If this argument is not specified, no feature track will
be drawn. Features will be drawn with colours provided in  \code{featcol}.}

\item{genes}{A GRanges object with exon structure for each transcript/gene.
If not included, no track will be drawn for gene/transcript structure.
The expected mcols in this object are \code{type}, \code{gene}, \code{exon} \code{transcript}
and \code{symbol}. See data(ex_trans) for an example.}

\item{coverage}{A named list of BigWigFileList objects containing the
primary tracks to show coverage for. Each list element will be drawn on a
separate track, with elements within each BigWigFileList shown on the same
track. List names will become track names. Alternatively, a single
BigWigFileList will plot all individual files on separate tracks.
If not included, no coverage tracks will be drawn.}

\item{annotation}{Annotations for the coverage track(s).
A single GRangesList if coverage is a BigWigListList.
If coverage is supplied as a list of BigWigFileLists, a named list of
GRangesList objects for each coverage track being annotatated. Names must
match those given for coverage.}

\item{zoom}{Multiplicative factor for zooming in and out}

\item{shift}{Shift the plot. Applied after zooming}

\item{max}{The maximum width of the plotting region. Given that the width of
the final plotting window will be determined by any HiC interactions, this
argument excludes any interactions beyond this distance. Plotting can be
somewhat slow if any long range interactions are included. Ignored if no HiC
interactions are supplied.}

\item{axistrack}{logical. Add an AxisTrack()}

\item{cytobands}{Cytogenetic bands to be displayed on each chromosome.
See data('grch37.cytobands') for the correct format. Only drawn if a
cytobands data.frame is provided.}

\item{covtype}{The plot type for coverage. Currently only lines ("l")
and heatmaps ("heatmap") are supported}

\item{linecol}{If passing a BigWigFileList to coverage, a vector of colours.
If passing a list of BigWigFileList objects to coverage, a list of colours
with structure that matches the object being passed to coverage, i.e. a
named list of the same length, with elements who's length matches each
BigWigFileList. Only used if covtype = "l".}

\item{gradient}{Colour gradient for heatmaps}

\item{hiccol}{list with names \code{"anchors"} and \code{"interactions"}. Colours
are passed to these elements}

\item{featcol}{Named vector (or list) of colours for each feature. Must be
provided if drawing features}

\item{genecol}{Named vector (or list) of colours for each gene category}

\item{annotcol}{Colours matching the coverage annotations}

\item{highlight}{Outline colour for the highlight track. Setting this to
\code{NULL} will remove the highlight}

\item{hicsize, featsize, genesize, covsize, annotsize}{Relative sizes for each track (hic, features, genes, coverage & annotation)}

\item{hicname, featname}{Names displayed in the LHS panel}

\item{featstack}{Stacking for the fature track}

\item{collapseTranscripts}{Passed to \link[Gviz]{GeneRegionTrack} for the
genes track. Defaults to \code{"auto"} for automatic setting. If the number of
transcripts to be plotted is > \code{maxtrans}, the argument will be
automatically set to \code{"meta"}, otherwise this will be passed as \code{FALSE} which
will show all transcripts.}

\item{maxTrans}{Only used if \code{collapseTranscripts} is set to "auto".}

\item{ylim}{If a numeric vector, this will be passed to all coverage tracks.
Alternatively, a named list of y-limits for each coverage track with names
that match those in each element of the coverage list.}

\item{...}{Passed to \link[Gviz]{DataTrack} for the \strong{coverage tracks} only.
Useful arguments may be things like \code{legend}}

\item{fontsize}{Applied across all tracks}

\item{cex.title}{Passed to all tracks}

\item{rotation.title}{Passed to all tracks}

\item{col.title}{Passed to all tracks}

\item{background.title}{Passed to all tracks}

\item{title.width}{Expansion factor passed to \link[Gviz]{plotTracks}, and
used to widen the panels on the LHS of all tracks.
Can have unpredictable effects on the font
size of y-axis limits due to the algorithm applied by \code{plotTracks}}
}
\value{
A Gviz object
}
\description{
Plot a region with showing HiC, Features, Genes and Coverage
}
\details{
Convenience function for plotting a common set of tracks. All tracks are
optional. For more fine control, users are advised to simply use Gviz
directly.

The primary tracks defined in this function are H (HiC), F (features), G
(genes), and C (coverage). Axis and Ideogram tracks are an additional part of
this visualisation, with the Ideogram also being optional

Use all tracks specific to this dataset to generate a simple visualisation.
In descending order the tracks displayed will be:
\enumerate{
\item HiC Interactions (if supplied)
\item Regulatory features
\item Genes/genes
\item Coverage tracks as supplied
}

All tracks are optional and will simply be omitted if no data is supplied.
See individual sections below for a more detailed explanation of each track

If wanting a single track of genes, simply pass a GRanges object in the
format specified for a \link[Gviz]{GeneRegionTrack}. Passing a GRangesList
with the same format will yield an individual track for each list element,
with each track shown by default as a separate colour. This can be used for
showing Up/Down-regulated genes, or Detected/Undetected genes.

If passing a BigWigFileList for the coverage track, each file within the
object will be drawn on a separate track. If specified, the same y-limits
will be applied to each track
If passing a list of BigWigFileList
objects, each list element will be drawn as a single track with the
individual files within each BigWigFileList overlaid within each track.

Cytogenetic band information must be in the structure required by
\link[Gviz]{IdeogramTrack}, with data for both GRCh37 and GRCh38 provided in
this package (\link{grch37.cytobands}, \link{grch38.cytobands}).

A highlight overlay over the GRanges provided as the \code{gr} argument will be
added if a colour is provided. If set to NULL, no highlight will be added.
}
\section{Displaying HiC Interactions}{


The available arguments for displaying HiC Interactions are defined below.
If \code{hic} is supplied, a single \link[GenomicInteractions]{InteractionTrack}
will be added displaying
all interactions with an anchor within the range specified by \code{gr}.
Only interactions with an anchor explicitly overlapping \code{gr} will be shown.
If no interactions are found within \code{gr}, the track will not be displayed.
The \strong{plotting range will expand to incorporate these interactions}, with
the paramater \code{max} providing an upper limit on the displayed range.

\describe{
\item{hic}{This is the \code{GInteractions} object required for inclusion of
a HiC track in the final output. Will be ignored if not supplied}
\item{hiccol}{Determines the colours used for display of anchors and
interactions}
\item{hicsize}{Relative size of the track compared to others}
\item{hicname}{The name to display on the LHS panel}
\item{max}{The maximum width of the plotted region. If multiple long-range
interactions are identified, this provides an upper limit for the display.
This defaults to \verb{10Mb}.}
}
}

\section{Displaying Features}{


If wanting to add an \link[Gviz]{AnnotationTrack} with regions defined as
'features', the following arguments are highly relevant.
All are ignored if \code{features} is not provided.

\describe{
\item{features}{A named \code{GRangesList}. Each element will be considered as
a separate feature and drawn as a block in a distinct colour. Any \code{mcols}
data will be ignored.}
\item{featcol}{A \strong{named} vector (or list) providing a colour for each
element of \code{features}}
\item{featname}{The name to display on the LHS panel}
\item{featstack}{Stacking to be applied to all supplied features}
\item{featsize}{Relative size of the track compared to others}
}
}

\section{Displaying Genes And Transcripts}{


To display genes or transcripts, simply provide a single \code{GRanges} object if
you wish to display all genes on a single track.
The \code{mcols} element of this object should contain the columns \code{feature},
\code{gene}, \code{exon}, \code{transcript} and \code{symbol} as seen on the
\link[Gviz]{GeneRegionTrack} help page.

Alternatively, a \code{GRangesList} can be provided to display genes on separate
tracks based on their category.
This can be useful for separating and colouring Up/Down regulated genes in a
precise way.
All elements should be as described above.
Again, all parameters associated with this track-set will be ignored of no
object is supplied to this argument.

\describe{
\item{genes}{A \code{GRanges} or \code{GRangesList} object as described above}
\item{genecol}{A single colour if supplying a \code{GRanges} object, or a
\strong{named} vector/list of colours matching the \code{GRangesList}}
\item{genesize}{Relative size of the track compared to others}
\item{collapseTranscripts}{Passed to all tracks. See the GeneRegionTrack
section in \link[Gviz]{settings} for detail regarding possible arguments.
If genes is a \code{GRangesList}, can be a \strong{named} vector/list with names
matching the names of the \code{genes} object.
}
}
}

\section{Displaying Coverage Tracks}{


This section contains the most flexibility and can take two types of input.
The first option is a \code{BigWigFileList}, which will lead to each BigWig file
being plotted on it's own track.
An alternative is a list of \code{BigWigFileList} objects.
In this case, each list element will be plotted as a separate track,
with all individual \code{BigWig} files within each list element
overlaid within the relevant track.

In addition to the coverage tracks, annotations can be added to each
\code{BigWigFileList} in the form of coloured ranges, indicating anything of the
users choice. Common usage may be to indicate regions with binding of a
ChIP target is found to be detected, unchanged, gained or lost.

\describe{
\item{coverage}{A \code{BigWigFileList} or \code{list} of \code{BigWigFileList} objects.
A single \code{BigWigFileList} will be displayed with each individual file on a
separate track with independent y-axes. Each element of the
\code{BigWigFileList} \strong{must be named} and these names will be displayed on the
LHS panels
A list of \code{BigWigFileList} objects will be displayed with each list element
as a separate track, with any \code{BigWig} files overlaid using the same
y-axis. The list \strong{must be named} with these names displayed on the LHS
panel. Each internal \code{BigWig} within a \code{BigWigFileList} must also be named.
}
\item{covtype}{Currently only lines (\code{covtype = "l"}) and
heatmaps (\code{covtype = "heatmap"}) are supported. Colours can be
specified using the arguments below}
\item{linecol}{Can be a single colour applied to all tracks, or a \emph{named}
vector (or list) of colours. If \code{coverage} is a single \code{BigWigFileList},
these names should match the names of this object exactly.
If \code{coverage} is a list of \code{BigWigFileList} objects, \code{linecol} should be
a list with matching names. Each element of this list should also be a
\strong{named} vector with names that exactly match those of each corresponding
\code{BigWigFileList}.}
\item{gradient}{A colour gradient applied to all heatmap tracks. No
specific structure is required beyond a vector of colours.}
\item{covsize}{Relative size of the tracks compared to others}
\item{ylim}{Can be a vector of length 2 applied to all coverage tracks.
Alternatively, if passing a list of \code{BigWigFlieList} objects to the
\code{coverage} argument, this can be a \strong{named} list of numeric vectors with
names matching \code{coverage}}
\item{annotation}{Each \code{BigWigFileList} needs annotations to be passed to
this argument as a \strong{named} \code{GRangesList}, with names being used to
associate unique colours with that set of ranges. If \code{coverage} is a
\code{BigWigFileList} a simple \code{GRangesList} would be supplied and a single
'annotation' track will appear at the top of the set of coverage tracks.
If \code{coverage} is a \code{list}, then a \strong{named} list of \code{GRangesList} objects
should be supplied, with each being displayed above the corresponding track
from the \code{coverage} object.}
\item{annotcol}{A vector of colours corresponding to all names within all
\code{GRangesList} elements supplied as \code{annotation}. It is assumed that the
same colour scheme will be applied to all annotation tracks and, as such,
the colours should \strong{not} be provided as a list which matches the
coverage tracks. Instead, every named element anywhere in the annotation
GRanges, across all of the tracks must be included as a colour}
\item{annotsize}{Relative size of the tracks compared to others}
}
}

\examples{
\donttest{
library(rtracklayer)
## Make sure we have the cytobands active
data(grch37.cytobands)

## Prepare the HiC, promoter & transcript information
data(ex_hic, ex_trans, ex_prom)
ex_features <- GRangesList(Promoter = ex_prom)
featcol <- c(Promoter = "red")

## Prepare the coverage
fl <- system.file(
"extdata", "bigwig", c("ex1.bw", "ex2.bw"), package = "extraChIPs"
)
bwfl <- BigWigFileList(fl)
names(bwfl)  <- c("ex1", "ex2")
bw_col <- c(ex1 = "#4B0055", ex2 = "#007094")

## Define the plotting range
gr <- GRanges("chr10:103862000-103900000")

## Now create the basic plot
plotHFGC(
  gr,
  hic = ex_hic, features = ex_features, genes = ex_trans, coverage = bwfl,
  featcol = featcol, linecol = bw_col, cytobands = grch37.cytobands
)

plotHFGC(
  gr,
  hic = ex_hic, features = ex_features, genes = ex_trans, coverage = bwfl,
  featcol = featcol, linecol = bw_col, cytobands = grch37.cytobands,
  maxTrans = 1
)
}

}
