% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RNAfeatures.R
\name{RNAfeatures}
\alias{RNAfeatures}
\title{Summarise the distribution of sRNA clusters across genomic features}
\usage{
RNAfeatures(
  data,
  annotation,
  repeats = NULL,
  promoterRegions = 1000,
  percentage = TRUE
)
}
\arguments{
\item{data}{data.frame; generated by \code{\link[=RNAimport]{RNAimport()}}}

\item{annotation}{path; URL or connection to a GFFFile object. A genome
reference annotation file (.gff/.gff1/.gff2/.gff3). Can be in compressed
format (gzip).}

\item{repeats}{path; URL or connection to a GFFFile object. A genome
reference annotation file, which only contains information on repeat
sequences in the genome (.gff/.gff1/.gff2/.gff3). By default, this is not
required, however if there is a specific repeats annotation file for the
genome it is suggested to supply it. Can be in compressed format (gzip).}

\item{promoterRegions}{numeric; defines the upstream promoter region of
genes. Default is 1000, which refers to promoters set at 1Kb upstream of
genes}

\item{percentage}{logical; define whether to return the results as a
percentage of the total or returned as a count value representing the
number of sRNA clusters that overlap with a given genomic feature. Default is
\code{TRUE}.}
}
\value{
Returns a table containing the number or percentage of overlaps in
the supplied sRNA data set with genomic features within supplied annotation
and/or with repeats.
}
\description{
Calculates the number of genomic features within the supplied
annotations and calculates the number of sRNA clusters which overlap with
these genomic features. Based on the features within the provided annotation.
}
\details{
\code{RNAfeatures} calculates the number or percentage of sRNA clusters which
overlap with genomic features based on their genomic coordinates.
}
\examples{
data("sRNA_data")
features <- RNAfeatures(data = sRNA_data,
                       annotation = system.file("extdata",
                       "reduced_chr2_Tomato.gff.gz", package="mobileRNA"))
                       
}
\seealso{
\code{\link[=RNAmergeAnnotations]{RNAmergeAnnotations()}} to merge 2 GFF files into 1.
}
