% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mobileRNA-package.R
\docType{package}
\name{mobileRNA}
\alias{mobileRNA}
\alias{mobileRNA-package}
\title{mobileRNA: Explore RNA mobilome & population-scale changes}
\description{
Uses small RNA or messenger RNA sequencing data in two conditions and
identifies changes in the RNA population. \code{mobileRNA} was primarily designed
for the identification of a putative RNA mobilome in a chimeric system. For
example, in plant graft systems. As input, \code{mobileRNA} takes sRNAseq or
mRNAseq fastq files. Output consists of a data frame with putative
differences between two conditions along with a number of plots.
}
\details{
The most important functions in the \pkg{mobileRNA} are:
\describe{
\item{\code{\link{RNAmergeGenomes}}}{Merge two genome assembly files (FASTA).}
\item{\code{\link{RNAmergeAnnotations}}}{Merge two genome annotation files
(GFF).}
\item{\code{\link{mapRNA}}}{Pre-processing of sRNAseq and mRNAseq
(alignment, raw count, cluster analysis).}
\item{\code{\link{RNAimport}}}{Reads the pre-processing report files into a
dataframe for all conditions}
\item{\code{\link{RNAdicercall}}}{Calculates the consensus sRNA
dicercall class.}
\item{\code{\link{RNAsubset}}}{Subsets the data set based on the sRNA class.}
\item{\code{\link{RNAdifferentialAnalysis}}}{Undertakes differential
analysis with either the edgeR or DESeq2 method.}
\item{\code{\link{RNAmobile}}}{Identify putative RNA molecules produced by
the non-tissue sample genome}
\item{\code{\link{RNApopulation}}}{Identify gained/lost RNA populations
between treatment and control conditions.}
\item{\code{\link{RNAsummary}}}{Summarise the differential abundance of
RNAs.}
\item{\code{\link{RNAreorder}}}{Reorder the data frame for differential
analysis, ensuring control verse treatment comparison.}
\item{\code{\link{RNAsequences}}}{Extract RNA sequence from sRNA clusters.}

\item{\code{\link{RNAattributes}}}{Overlap the genomic features related to
the sRNA clusters.}
\item{\code{\link{RNAdistribution}}}{Plot the distribution of sRNA classes
based on nucleotide length.}
\item{\code{\link{plotHeatmap}}}{Heatmap of log-transformed normalization
data.}
\item{\code{\link{plotSampleDistance}}}{Plots a sample distance heatmap for
quality control.}
\item{\code{\link{plotSamplePCA}}}{Plots a PCA plot, customize ratio,
colours and shapes.}
\item{\code{\link{RNAfeatures}}}{Summarise the distribution of sRNA clusters
across genomic features.}
\item{\code{\link{RNAdf2se}}}{Convert a \code{mobileRNA} dataframe to a
SummarizedExperiment object. }
}
}
\seealso{
See \code{vignette("mobileRNA", package = "mobieRNA")} for an
overview of the package.
}
\author{
Katie Jeynes-Cupper \email{kej031@student.bham.ac.uk},
Marco Catoni \email{m.catoni@bham.ac.uk}
Maintainer: Katie Jeynes-Cupper \email{kej031@student.bham.ac.uk}
}
\keyword{internal}
