% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/keptProbaWin.R
\name{.keptProbaWin}
\alias{.keptProbaWin}
\title{Get the probability of being kept for each window}
\usage{
.keptProbaWin(winPosAlignments, winNegAlignments, winWidth, winStep,
  threshold, pvalueThreshold, errorRate, mustKeepWin, minCov, maxCov,
  getWin, useCoverage = FALSE)
}
\arguments{
\item{winPosAlignments}{an object returned by getWinOverlapEachReadFragment for 
positive reads}

\item{winNegAlignments}{an object returned by getWinOverlapEachReadFragment for 
negative reads}

\item{winWidth}{the width of the sliding window, 1000 by default.}

\item{winStep}{the winStep length to sliding the window, 100 by default.}

\item{threshold}{the strand proportion threshold to test whether to keep a 
window or not.}

\item{pvalueThreshold}{threshold of p-value}

\item{errorRate}{the probability that an RNA read takes the false strand. 
0.01 by default}

\item{mustKeepWin}{the windows that must be kept regardless their strand 
proportion}

\item{minCov}{In the case that \code{useCoverage=FALSE}, if a window has 
less than \code{minCov} reads, then it will be rejected regardless of the 
strand proportion. 
For the case that \code{useCoverage=TRUE}, if a window has max coverage
least than \code{minCov}, then it will be rejected. 0 by default}

\item{maxCov}{In the case that \code{useCoverage=FALSE}, if a window has 
more than \code{maxCov} reads, then it will be kept regardless of the strand 
proportion. 
For the case that \code{useCoverage=TRUE}, if a window has max coverage 
more than \code{maxCov}, then it will be kept. If 0 then it doesn't have 
effect on selecting window. 0 by default.}

\item{getWin}{if TRUE, the function will return a data frame containing the 
information of all windows. It's FALSE by default.}

\item{useCoverage}{if TRUE, then the strand information in each window 
corresponds to the sum of coverage coming from positive/negative reads; 
and not the number of positive/negative reads as default.}
}
\value{
A list of 2 numeric-Rle objects containing keeping probability of 
each +/- alignments. 
If \code{getWin=TRUE} then the list contains an additional DataFrame for the 
number of reads and coverage of the input window +/- alignments
}
\description{
Calculate the keeping probability of each window based on its 
positive/negative proportion
}
\keyword{internal}
