% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getWinOverlapEachIRange.R
\name{getWinOverlapEachIRange}
\alias{getWinOverlapEachIRange}
\title{Get the ranges of sliding windows that overlap each range of an 
IRanges object.}
\usage{
getWinOverlapEachIRange(x, winWidth = 1000L, winStep = 100L,
  readProp = 0.5, maxWin = Inf)
}
\arguments{
\item{x}{an IRanges object containing the start and end position of 
each read fragment.}

\item{winWidth}{the width of the sliding window, 1000 by default.}

\item{winStep}{the step length to sliding the window, 100 by default.}

\item{readProp}{A read is considered to be included in a window if at least 
\code{readProp} of it is in the window. Specified as a proportion.}

\item{maxWin}{The maximum window ID}
}
\value{
An IRanges object containing the index of the windows overlapping 
each read fragment
}
\description{
Get the ranges of sliding windows that overlap each range of an 
IRanges object.
}
\details{
This finds the windows that overlap each range of the input IRanges object. 
Each range corresponds to a read fragment. This allows the total number of 
read fragments within a window to be calculated simply using \link{coverage}.
}
\examples{
library(IRanges)
x <- IRanges(start=round(runif(100,1000,10000)),width=100)
getWinOverlapEachIRange(x)

}
