\name{plotPriors}
\alias{plotPriors}
\title{Plot prior using parameter vector}
\description{
Plot appropriate priors using parameters from vector
}
\usage{
plotPriors(parameter.vec)
}
\details{
This function takes the parameter vector that will be used for network inference function and
plots the priors associated with the parameters given.
}
\arguments{
\item{parameter.vec}{MCMC parameter vector of the type generated by e.g. mcmc.defaultParams_Linear}
}

\references{
Morrissey, E.R., Juarez, M.A., Denby, K.J. and Burroughs, N.J. 2010. On reverse engineering of gene interaction 
networks using time course data with repeated measurements.  Bioinformatics 2010; doi: 10.1093/bioinformatics/btq421

Morrissey, E.R., Juarez, M.A., Denby, K.J. and Burroughs, N.J. 2011 Inferring the time-invariant 
topology of a nonlinear sparse gene regulatory network using fully Bayesian spline autoregression
Biostatistics 2011; doi: 10.1093/biostatistics/kxr009
}

\seealso{
\code{\link{mcmc.defaultParams_gauss}}, \code{\link{mcmc.defaultParams_Linear}}, 
	\code{\link{mcmc.defaultParams_nonLinear} }, \code{\link{mcmc.defaultParams_student} }.
}
\keyword{PlotPriors}
\examples{
    # Get default parameters
    nonLinearNet.params <- mcmc.defaultParams_nonLinear()

    # Change run length
    nonLinearNet.params[1] <- 150000

    # Change prior on smoothness parameter
    nonLinearNet.params[6] <- 30000 # Change truncation 
    nonLinearNet.params[12] <- 3 # Concentrate more mass close to linear region

    # Plot to check changes
    plotPriors(nonLinearNet.params)
}
