% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hicpro2bedpe.R
\name{hicpro2bedpe}
\alias{hicpro2bedpe}
\title{Convert HiC-Pro results to BEDPE format}
\usage{
hicpro2bedpe(mat, bed)
}
\arguments{
\item{mat}{The 3 column sparse upper triangular matrix
from HiC-Pro.}

\item{bed}{The BED file containing the mappings for
for the matrix.}
}
\value{
A list with two items. Item 1, "cis"
    contains the intra-chromosomal contact matrices,
    one per chromosome.
    Item 2, "trans" contains the inter-chromsomal
    contact matrix.
}
\description{
Convert HiC-Pro results to BEDPE format
}
\details{
HiC-Pro will produce a .matrix file
    and a .bed file as the final aligned product
    of the alignment process. These files should
    be read into R using read.table() or similar
    and then entered as the mat and bed inputs 
    to this function. The function will convert
    the data into a format useable for HiCcompare.
    The cis matrices in the results can be 
    directly input into create.hic.table() as
    sparse matrices.
}
\examples{
\dontrun{
 # read in data
 mat <- read.table("hic_1000000.matrix")
 bed <- read.table("hic_1000000_abs.bed")
 # convert to BEDPE
 dat <- hicpro2bedpe(mat, bed)
}
}
