% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manhattan_plot.R
\name{manhattan_plot}
\alias{manhattan_plot}
\title{Create a Manhattan plot for the results of HiCcompare}
\usage{
manhattan_plot(hic.table, adj.p = TRUE, alpha = 0.05, return_df = FALSE)
}
\arguments{
\item{hic.table}{a hic.table object that has been normalized
and had differences detected.}

\item{adj.p}{Logical, should the adjusted p-value be used (TRUE)
of the raw p-value (FALSE)?}

\item{alpha}{The alpha level for calling a p-value significant.}

\item{return_df}{Logical, should the data.frame built to be used
for plotting be returned? If TRUE then the data.frame will be
returned and the plot will only be printed.}
}
\value{
A manhattan plot.
}
\description{
Create a Manhattan plot for the results of HiCcompare
}
\details{
This function will produce a manhattan plot of the results
    of hic_compare(). Can be used to display which regions around found
    to be significantly different on the linear genome.
}
\examples{
# Create hic.table object using included Hi-C data in 
# sparse upper triangular matrix format
data('HMEC.chr22')
data('NHEK.chr22')
hic.table <- create.hic.table(HMEC.chr22, NHEK.chr22, chr = 'chr22')
# Plug hic.table into hic_loess()
result <- hic_loess(hic.table, Plot = TRUE)
# perform difference detection
diff.result <- hic_compare(result, Plot = TRUE)
# make manhattan plot
manhattan_plot(diff.result)
}
