% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qunet2xml.R
\name{qunet2xml}
\alias{qunet2xml}
\title{Convert newwork to XGMML}
\usage{
qunet2xml(net, minimum = 0.6,
  color = cbind(grDevices::rainbow(length(net[[2]]) - 1), "gray"))
}
\arguments{
\item{net}{Result of \code{\link{qunetwork}}}

\item{minimum}{cutoff, default: 0.6}

\item{color}{default: cbind(grDevices::rainbow(length(net[[2]]) - 1), 'gray')}
}
\value{
Text of XGMML
}
\description{
This function can convert the constructed co-expression networks into XGMML format, which can be used to do further network analysis in Cytoscape, Biomax and JNets.
}
\examples{
# Load microarray matrix
data(BicatYeast)
res <- biclust::biclust(BicatYeast[1:50, ], method=BCQU(), verbose = FALSE)
# Get all biclusters
net <- qunetwork(BicatYeast[1:50, ], res, group = c(4, 13), method = 'spearman')
# Save the network to a XGMML file
sink('tempnetworkresult.gr')
qunet2xml(net, minimum = 0.6, color = cbind(grDevices::rainbow(length(net[[2]]) - 1), 'gray'))
sink()
# You can use Cytoscape, Biomax or JNets open file named tempnetworkresult.gr
}
\seealso{
\code{\link{qunetwork}} \code{\link{QUBIC}}
}

