% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TrajectoryGeometry.R
\name{analyseBranchPoint}
\alias{analyseBranchPoint}
\title{Analyse branch point.}
\usage{
analyseBranchPoint(
  attributes,
  pseudotime,
  randomizationParams,
  statistic,
  start = (max(pseudotime) - min(pseudotime)) * 0.25,
  stop = (max(pseudotime) - min(pseudotime)) * 0.75,
  step = (max(pseudotime) - min(pseudotime)) * 0.05,
  nSamples = 1000,
  nWindows = 10,
  d = ncol(attributes),
  N = 1
)
}
\arguments{
\item{attributes}{- An n x d (cell x attribute) matrix of numeric attributes
for single cell data. Rownames should be cell names.}

\item{pseudotime}{- A named numeric vector of pseudotime values for cells.}

\item{randomizationParams}{- A character vector which is used to
control the production of randomized paths for comparison.}

\item{statistic}{- Allowable values are 'median', 'mean' or 'max'.}

\item{start}{- The first pseudotime value (percentage of the trajectory)
from which to analyse the trajectory from.
Defaults to 25\% of the way through the trajectory.}

\item{stop}{- The last pseudotime value (as a percentage of the trajectory)
from which to analyse the trajectory from.
Defaults to 75\% of the way through the trajectory.}

\item{step}{- The size of the step to take between successively later
starting points in pseudotime.
Defaults to 5\% of the trajectory length.}

\item{nSamples}{- The number of sampled paths to generate (defaults to 1000).}

\item{nWindows}{- The number of windows pseudotime should be split into to
sample cells from (defaults to 10).}

\item{d}{- The dimension under consideration.  This defaults to
ncol(attributes).}

\item{N}{- The number of random paths to generated for statistical
comparison to the given path (defaults to 1000).}
}
\value{
This returns a list of results for analyseSingleCellTrajectory,
   named by trajectory starting point.
   Each result from analyseSingleCellTrajectory is a list which contains an
   entry for each sampled path.
   Each  of these entries is a list containing information comparing the
   sampled path in question
   to random paths. The entries consist of:
   pValue - the p-value for the path and statistic in question;
   sphericalData - a list containing the projections of the path to
    the sphere, the center of that sphere and the statistic for
    distance to that center;
   randomDistances - the corresponding distances for randomly chosen;
    paths;
   randomizationParams - the choice of randomization parameters
}
\description{
This function takes a single cell trajectory and analyses it starting from
successively later points in pseudotime, with the rationale that a more
consistent directionality will be followed after the branch point.
}
\examples{
chol_branch_point_results = analyseBranchPoint(chol_attributes[,seq_len(3)],
                         chol_pseudo_time[!is.na(chol_pseudo_time)],
                         randomizationParams = c('byPermutation',
                                         'permuteWithinColumns'),
                         statistic = "mean",
                         start = 0,
                         stop = 50,
                         step = 5,
                         nSamples = 10,
                         N = 1)
}
