% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TrajectoryGeometry.R
\name{analyseSingleCellTrajectory}
\alias{analyseSingleCellTrajectory}
\title{Analyse a single cell trajectory.}
\usage{
analyseSingleCellTrajectory(
  attributes,
  pseudotime,
  randomizationParams,
  statistic,
  nSamples = 1000,
  nWindows = 10,
  d = ncol(attributes),
  N = 1000
)
}
\arguments{
\item{attributes}{- An n x d (cell x attribute) matrix of numeric attributes
for single cell data. Rownames should be cell names.}

\item{pseudotime}{- A named numeric vector of pseudotime values for cells.}

\item{randomizationParams}{- A character vector which is used to
control the production of randomized paths for comparison.}

\item{statistic}{- Allowable values are 'median', 'mean' or 'max'.}

\item{nSamples}{- The number of sampled paths to generate (default 1000).}

\item{nWindows}{- The number of windows pseudotime should be split into to
sample cells from (defaults to 10).}

\item{d}{- The dimension under consideration.  This defaults to
ncol(attributes).}

\item{N}{- The number of random paths to generated for statistical
comparison to the given path (defaults to 1000).}
}
\value{
This returns a list, where each entry is itself a list containing
  information comparing a sampled path to random paths.
  These entries consist of:
  pValue - the p-value for the path and statistic in question;
  sphericalData - a list containing the projections of the path to
    the sphere, the center of that sphere and the statistic for
    distance to that center;
  randomDistances - the corresponding distances for randomly chosen;
    paths;
  randomizationParams - the choice of randomization parameters
}
\description{
This function analyses a single cell trajectory by sampling multiple paths
and comparing each path to random paths.
It takes vector of pseudotime values, and a matrix of attribute values
(cell x attribute).
It also optionally takes the number of pseudotime windows to sample a single
cell from. This defaults to 10.
The function returns a list of Answers for each comparison of a sampled path
to a random path.
}
\examples{
chol_answers = analyseSingleCellTrajectory(chol_attributes[,seq_len(3)],
                                         chol_pseudo_time_normalised,
                                         nSamples = 10,
                                         randomizationParams =
                                                     c('byPermutation',
                                                   'permuteWithinColumns'),
                                         statistic = "mean",
                                         N = 1)
hep_answers = analyseSingleCellTrajectory(hep_attributes[,seq_len(3)],
                                         hep_pseudo_time_normalised,
                                         nSamples = 10,
                                         randomizationParams =
                                                   c('byPermutation',
                                                   'permuteWithinColumns'),
                                         statistic = "mean",
                                         N = 1)
}
