% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Add_custom_vcfs.R
\name{add_custom_vcf_to_database}
\alias{add_custom_vcf_to_database}
\title{add_custom_vcf_to_database
This function adds the variants of parsed custom CCLs to a monet DB instance}
\usage{
add_custom_vcf_to_database(
    vcf_input_files,
    ref_gen = "GRCH37",
    library_name = "CUSTOM",
    n_threads = 1,
    test_mode = FALSE
)
}
\arguments{
\item{vcf_input_files}{a character vector containing the input vcf files.
This may be one or many vcf files.}

\item{ref_gen}{a character string specifying the reference genome version.
All training sets are associated with a reference genome version.
Default is \code{"GRCH37"}.}

\item{library_name}{a character string giving the name of the library to add the
cancer cell lines to. Default is \code{"CUSTOM"}. 
Library name will be automatically added as a suffix to the identifier.}

\item{n_threads}{an integer specifying the number of threads to be used.}

\item{test_mode}{Is this a test? Just for internal use}
}
\value{
Message wheather the adding was successful
}
\description{
add_custom_vcf_to_database
This function adds the variants of parsed custom CCLs to a monet DB instance
}
\examples{
HT29_vcf_file = system.file("extdata/HT29_TEST.vcf", package = "Uniquorn");
add_custom_vcf_to_database(
    vcf_input_files = HT29_vcf_file,
    library_name = "CELLMINER",
    ref_gen = "GRCH37",
    n_threads = 1,
    test_mode = TRUE
)

}
