% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/consensusPart.R
\name{consensusPart}
\alias{consensusPart}
\title{Consensus Partitions}
\usage{
consensusPart(sce)
}
\arguments{
\item{sce}{SingleCellExperiment}
}
\value{
A matrix grouping factor partition is replaced in metadata.
Consensus Partation also stored in colData\code{"part"}.
}
\description{
Derive consensus partitions of an ensemble fused lasso partitions.
}
\examples{
library(smurf)
sce <- makeSimulatedData()
sce <- preprocess(sce)
sce <- geneCluster(sce, G = 1:4)
f <- ratio ~ p(x, pen = "gflasso") # formula for the GFL
sce_sub <- fusedLasso(sce,
  formula = f, model = "binomial", genecluster = 1,
  niter = 2, ncores = 2, se.rule.nct = 3
)
sce_sub <- consensusPart(sce_sub)
}
