% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractResult.R
\name{extractResult}
\alias{extractResult}
\title{Extract results from an airpart analysis}
\usage{
extractResult(sce, estimates = c("ar", "svalue", "fsr", "lower", "upper"))
}
\arguments{
\item{sce}{SingleCellExperiment}

\item{estimates}{the estimates want to be extracted. Default is allelic ratio estimates,
can be \code{"svalue"}, \code{"fsr"}, \code{"lower"}(credible interval) and \code{"upper"}(credible interval)}
}
\value{
a DataFrame of estimates
}
\description{
results extracts a result table from an airpart analysis giving posterior allelic ratio estimates,
s values, false sign rate(fsr), upper confidence interval and lower confidence interval.
}
\examples{

sce <- makeSimulatedData()
sce <- preprocess(sce)
sce <- geneCluster(sce, G = 1:4)
sce_sub <- wilcoxExt(sce, genecluster = 1)
sce_sub <- allelicRatio(sce_sub)
ar <- extractResult(sce_sub)
ar
}
