% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster.R
\name{geneCluster}
\alias{geneCluster}
\title{Gene clustering based on allelic ratio matrix with pseudo-count}
\usage{
geneCluster(
  sce,
  G,
  method = c("GMM", "hierarchical"),
  minClusterSize = 3,
  plot = TRUE,
  ...
)
}
\arguments{
\item{sce}{SingleCellExperiment containing assays \code{"ratio_pseudo"} and
colData factor \code{"x"}}

\item{G}{An integer vector specifying the numbers of clusters for which the
BIC is to be calculated.
 The default is G=c(8, 12, 16, 20, 24).}

\item{method}{the method to do gene clustering. The default is the Gaussian
Mixture Modeling which
is likely to be more accurate. \code{"hierarchical"} represents
automatic hierarchical clustering which is faster to compute.}

\item{minClusterSize}{Minimum cluster size of \code{"hierarchical"} method.}

\item{plot}{logical, whether to make a PCA plot}

\item{...}{Catches unused arguments in indirect or list calls via do.call
as described in \code{\link[mclust]{Mclust}}}
}
\value{
gene cluster IDs are stored in the rowData column \code{cluster}
and a table of gene cluster is returned in metadata \code{geneCluster}
}
\description{
Gene clustering based on allelic ratio matrix with pseudo-count
}
\examples{

sce <- makeSimulatedData()
sce <- preprocess(sce)
sce <- geneCluster(sce, G = seq_len(4))
}
\references{
This function leverages Mclust from the mclust package, or hclust.

For mclust see:
Luca Scrucca and Michael Fop and T. Brendan Murphy, Adrian E. Raftery
"mclust 5: clustering, classification and density
estimation using {G}aussian finite mixture models"
2016. The R Journal. doi: 10.32614/RJ-2016-021
}
\seealso{
\code{\link[mclust]{Mclust}}
}
