% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeViolin.R
\name{makeViolin}
\alias{makeViolin}
\title{Posterior mean allelic ratio estimates in violin plots}
\usage{
makeViolin(sce, xlab = "cell type", ylim = c(0, 1))
}
\arguments{
\item{sce}{SingleCellExperiment}

\item{xlab}{the x axis name.}

\item{ylim}{the y axis range}
}
\value{
a ggplot2 object, \code{n} represents number of cells in that cell type.
}
\description{
Posterior mean allelic ratio estimates in violin plots
}
\examples{

sce <- makeSimulatedData()
sce <- preprocess(sce)
sce <- geneCluster(sce, G = 1:4)
sce_sub <- wilcoxExt(sce, genecluster = 1)
sce_sub <- allelicRatio(sce_sub)
makeViolin(sce_sub)
}
