% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shearwaterML.R
\name{betabinLRT}
\alias{betabinLRT}
\title{ShearwaterML}
\usage{
betabinLRT(
  counts,
  rho = NULL,
  truncate = 0.05,
  rho.min = 1e-04,
  rho.max = 0.8,
  maxvaf = 0.3,
  mindepth = 10,
  maxtruncate = 0.5
)
}
\arguments{
\item{counts}{The array of counts typically generated by loadAllData.}

\item{rho}{Use this variable to fix the dispersion parameter to a value of interest. Default: NULL, rho will be estimated from the data.}

\item{truncate}{Samples with variant allele frequencies higher than "truncate" will be excluded from the background error model.}

\item{rho.min}{If rho=NULL, rho will be estimated from the data in the interval [rho.min,rho.max].}

\item{rho.max}{If rho=NULL, rho will be estimated from the data in the interval [rho.min,rho.max].}

\item{maxvaf}{Sites with an average rate of mimatches higher than maxvaf will not be considered (e.g. SNPs or reference sites).}

\item{mindepth}{Minimum coverage required to test a site.}

\item{maxtruncate}{Maximum number of samples that can be excluded from the background error model by truncate for a site to be tested.}
}
\value{
A list with two arrays for P- and Q-values.
}
\description{
Maximum likelihood version of Shearwater producing p-values instead of Bayes factors.
}
\examples{
# code to be added
}
\references{
Martincorena I, Roshan A, Gerstung M, et al. (2015). High burden and pervasive positive selection of somatic mutations in normal human skin. _Science_ (Under consideration).
}
\author{
Inigo Martincorena and Moritz Gerstung
}
