% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deepSNV-methods.R
\docType{methods}
\name{control}
\alias{control}
\alias{control,deepSNV-method}
\title{Get control counts}
\usage{
control(deepSNV, ...)

\S4method{control}{deepSNV}(deepSNV, total = FALSE)
}
\arguments{
\item{deepSNV}{a \code{\link{deepSNV-class}} object}

\item{...}{Additional param passed to specific methods}

\item{total}{Logical. If true the sum of both strands is returned}
}
\value{
A matrix with the absolute frequencies summed over both strands.
}
\description{
Convenience function to obtain the control counts from a deepSNV object.
}
\examples{
data(HIVmix)
control(HIVmix)[1:10,]
control(HIVmix, total=TRUE)[1:10,]
}
