% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rsamtools-methods.R
\name{validate,BamFile-method}
\alias{validate,BamFile-method}
\alias{validate}
\alias{validate,BamFileList-method}
\title{Extension of the Rsamtools package}
\usage{
\S4method{validate}{BamFile}(obj, header = TRUE, cross.validation = TRUE)
}
\arguments{
\item{obj}{An object of the \code{\linkS4class{BamFile}} or
\code{\linkS4class{BamFileList}} class}

\item{header}{a boolean to (de)activate the check for a BAM
header}

\item{cross.validation}{a boolean - only valid for
\code{\linkS4class{BamFileList}} objects - to
(de)activate the cross validation of all the BAM files
header}
}
\value{
\code{validate} returns invisibly a vector of boolean.
Fails anyway if any file is missing.
}
\description{
Describes extensions to the Rsamtools package.
\itemize{
\item For \code{\linkS4class{BamFile}} and
\code{\linkS4class{BamFileList}} objects:
\itemize{
\item \code{validate} validates a \code{\linkS4class{BamFile}} or
\code{\linkS4class{BamFileList}} object.
}
}
}
\details{
\code{validate} checks whether the BAM file exists and if a BAI index is present.
}
\examples{
# retrieve the data
tdir <- tutorialData()

# get the bam file path from the Bioc cache
filenames <- dir(tdir,pattern="[A,C,T,G]{6}\\\\.bam$",full.names=TRUE)

# retrieve the index from the Bioc cache too
inxnames <- sapply(paste0(sub(".*_","",basename(filenames)),".bai"),fetchData)

bfl <-BamFileList(filenames,index=inxnames)

validate(bfl)

}
\seealso{
\itemize{
\item \code{\linkS4class{BamFile}}
\item \code{\linkS4class{BamFileList}}
}
}
\author{
Nicolas Delhomme
}
\keyword{methods}
