% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gep2pep.R
\docType{package}
\name{gep2pep-package}
\alias{gep2pep-package}
\alias{gep2pep}
\title{gep2pep: creation and analysis of Pathway Expression Profiles}
\description{
Pathway Expression Profiles (PEPs) are based on the expression of
pathways (or generic gene sets) belonging to a collection, as
opposed to individual genes. \code{gep2pep} supports the conversion
of gene expression profiles (GEPs) to PEPs and performs enrichment
analysis of both pathways and conditions.
}
\details{
\code{gep2pep} creates a local repository of gene sets, which can
also be imported from the MSigDB [1] database. The local repository
is in the \code{repo} format. When a GEP, defined as a ranked list
of genes, is passed to \code{\link{buildPEPs}}, the stored database
of pathways is used to convert the GEP to a PEP and permanently
store the latter.

One type of analysis that can be performed on PEPs and that is
directly supported by \code{gep2pep} is the Drug-Set Enrichment
Analysis (DSEA [2]). It finds pathways that are consistently
dysregulated by a set of drugs, as opposed to a background of other
drugs. Of course PEPs may refer to non-pharmacological conditions
(genetic perturbations, disease states, cell types, etc.) for
analogous analyses. See \code{\link{CondSEA}} function.

A complementary approach is that of finding conditions that
consistently dysregulate a set of pathways. This is the
pathway-based version of the Gene Set Enrichment Analysis
(GSEA). As an application example, this approach can be used to
find drugs mimicking the dysregulation of a gene by looking for
drugs dysregulating pathways involving the gene (this has been
published as the \code{gene2drug} tool [3]). See
\code{\link{PathSEA}}.

Both DSEA and gene2drug analyses can be performed using
preprocessed data from
\url{http://dsea.tigem.it/downloads.php}. The data include
Connectivity Map [4] GEPs (drug-induced gene expression profiles)
converted to PEPs in the form of a \code{gep2pep} repository.

Naming conventions:

\itemize{

  \item{pathway: }{any set of gene identifiers (not necessarily
  representing a molecular pathway).}

  \item{pathway collection: }{a set of pathways.}

  \item{pathway database: }{a set of pathway collections, like the
  MSigDB.}

  \item{Gene Expression Profile (GEP): }{a named vector where names
  are gene identifiers of the same type as those in the pathway
  database and elements are ranks ranging from 1 to the number of
  genes.}

  \item{Pathway Expression Profile (PEP): }{a ranked list of
  pathways, as converted from a GEP according to a pathway
  collection.}

  \item{condition: }{any transcriptomic-modelled biological state
  (drug treatment, gene knock-out, disease state, cell type, etc.)
  characterized by an induced GEP and therefore a PEP.}

  \item{gep2pep repository: }{a pathway database and possibly a
  related database of PEPs as created by the \code{gep2pep}
  package. It is implemented in \code{repo} format.}
}
}
\references{
[1] Subramanian A. et al. Gene set enrichment analysis: A
    knowledge-based approach for interpreting genome-wide
    expression profiles. PNAS 102, 15545-15550 (2005).

[2] Napolitano F. et al, Drug-set enrichment analysis: a novel tool
    to investigate drug mode of action. Bioinformatics 32, 235-241
    (2016).

[3] Napolitano, F. et al. gene2drug: a computational tool for
    pathway-based rational drug repositioning. Bioinformatics
    (2017). https://doi.org/10.1093/bioinformatics/btx800

[4] Lamb, J. et al. The Connectivity Map: Using Gene-Expression
    Signatures to Connect Small Molecules, Genes, and Disease. Science
    313, 1929-1935 (2006).
}
\author{
Francesco Napolitano \email{franapoli@gmail.com}
}
