% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gep2pep.R
\name{getDetails}
\alias{getDetails}
\title{Extracts the details matrix from \code{CondSEA} or \code{PathSEA}
output}
\usage{
getDetails(analysis, collection)
}
\arguments{
\item{analysis}{The output of either \code{CondSEA} or
\code{PathSEA}.}

\item{collection}{One of the names returned by
\code{getCollections}.}
}
\value{
A matrix including the ranks of each pathway (over rows)
    and each condition (over columns) used as input to
    \code{CondSEA} or \code{PathSEA}.
}
\description{
Extracts the details matrix from \code{CondSEA} or \code{PathSEA}
output
}
\examples{
db <- loadSamplePWS()
repo_path <- file.path(tempdir(), "gep2pepTemp")

rp <- createRepository(repo_path, db)
geps <- loadSampleGEP()
buildPEPs(rp, geps)

pgset <- c("(+)_chelidonine", "(+/_)_catechin")
psea <- CondSEA(rp, pgset)

getDetails(psea, "c3_TFT")

unlink(repo_path, TRUE)

}
\seealso{
CondSEA, PathSEA
}
