% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plotPeriodicityResults}
\alias{plotPeriodicityResults}
\title{Plot the output of getPeriodicity()}
\usage{
plotPeriodicityResults(
  results,
  periods = c(2, 20),
  filter_periods = TRUE,
  facet_control = TRUE,
  xlim = NULL,
  fdr_threshold = 0.05,
  ...
)
}
\arguments{
\item{results}{The output of getPeriodicity function.}

\item{periods}{Vector a numerical vector of length 2, to specify the
x-axis limits}

\item{filter_periods}{Boolean Should the x-axis be 
constrained to the periods?}

\item{facet_control}{Boolean should the shuffling plots be faceted?}

\item{xlim}{Integer x axis upper limit in raw and norm. distograms}

\item{fdr_threshold}{Float, significance threshold}

\item{...}{Additional theme arguments passed to theme_ggplot2()}
}
\value{
list A list containing four ggplots
}
\description{
This function plots some results from the result of getPeriodicity(). 
It plots the raw distogram, the distance-decay normalized 
distogram and the resulting PSD values. If a shuffled control has
been performed by getPeriodicity(), it also displays it.
}
\examples{
data(ce11_TSSs)
periodicity_result <- getPeriodicity(
    ce11_TSSs[['Ubiq.']][1:100],
    genome = 'BSgenome.Celegans.UCSC.ce11',
    motif = 'TT', 
    BPPARAM = setUpBPPARAM(1)
)
head(periodicity_result$PSD)
plotPeriodicityResults(periodicity_result)
plotPeriodicityResults(periodicity_result, xlim = 150)
plotPeriodicityResults(
    periodicity_result, xlim = 150, filter_periods = FALSE
)
plotPeriodicityResults(
    periodicity_result, xlim = 150, facet_control = FALSE
)
}
