% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scHOT_plot.R
\name{plotColouredExpression}
\alias{plotColouredExpression}
\title{plotColouredExpression}
\usage{
plotColouredExpression(
  scHOT,
  genes,
  genes_delimeter = "_",
  branches = NULL,
  ranked_by = NULL,
  subsetBranch = NULL,
  n = 3,
  fittedline = TRUE,
  assayName = NULL
)
}
\arguments{
\item{scHOT}{A scHOT object.}

\item{genes}{is either a single character string with a delimeter,
or a length two character vector}

\item{genes_delimeter}{is the delimeter to split into two gene names
if genes is provided as a single character}

\item{branches}{A character indicates that the colnames stored
the branch information in colData}

\item{ranked_by}{A character indicates that the colnames stored
the ranking information of the cells in colData, such as trajectory time,
if it is NULL, it will be ranked based on the branch information.}

\item{subsetBranch}{subsetBranch is a character vector containing
the names of the branches to be plotted. If NULL it will plot all branches}

\item{n}{number of panels to split ranked samples into, default 3.}

\item{fittedline}{logical default TRUE, add a lm straight line to the plot}

\item{assayName}{the name of the assay that are used to plot.}
}
\value{
\code{ggplot} a ggplot object of scatterplots of expression
split by sample ordering
}
\description{
the plotColouredExpression function plots an n-panel scatterplot
of the gene pairs split by early, mid, and late in the sample ordering.
}
\examples{

data(liver)

scHOT_traj <- scHOT_buildFromMatrix(
mat = liver$liver_branch_hep,
cellData = list(pseudotime = liver$liver_pseudotime_hep),
positionType = "trajectory",
positionColData = "pseudotime")

scHOT_traj

plotColouredExpression(scHOT_traj, c("Cdt1","Top2a"), n = 5)

}
