% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scHOT.R
\name{scHOT}
\alias{scHOT}
\title{scHOT}
\usage{
scHOT(
  scHOT,
  testingScaffold = NULL,
  weightMatrix = NULL,
  positionType = NULL,
  positionColData = NULL,
  nrow.out = NULL,
  averageAcrossTrajectoryTies = FALSE,
  higherOrderFunction = NULL,
  higherOrderFunctionType = NULL,
  numberPermutations = 1000,
  numberScaffold = 100,
  storePermutations = TRUE,
  higherOrderSummaryFunction = sd,
  parallel = FALSE,
  BPPARAM = BiocParallel::SerialParam(),
  usenperm_estimate = FALSE,
  nperm_estimate = 10000,
  maxDist = 0.1,
  plot = FALSE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{scHOT}{A scHOT object}

\item{testingScaffold}{A matrix with rows for each testing combination}

\item{weightMatrix}{A matrix indicates the weight matrix for scHOT analysis}

\item{positionType}{A string indicating the position type,
either "trajectory" or "spatial"}

\item{positionColData}{Either trajectory or spatial information
for each sample. If positionType is "trajectory"
then positionColData should be a character or numeric indicating
the subset of colData of the scHOT object.
If positionType is "spatial" then positionColData should be
a character or numeric vector indicating the subset of colData that
give the full spatial coordinates.}

\item{nrow.out}{The number of weightings to include for testing,
a smaller value is faster for computation}

\item{averageAcrossTrajectoryTies}{Logical indicating whether ties
in the trajectory should be given the same local weights}

\item{higherOrderFunction}{A function object indicates the
higher order function}

\item{higherOrderFunctionType}{is "weighted" or "unweighted",
determines if there
is a weighting argument in the higher order function}

\item{numberPermutations}{The number of permutations,
set as 1000 by default}

\item{numberScaffold}{The number of testing scaffolds to
perform permutations, set as 100 by default}

\item{storePermutations}{a logical flag on whether
permutation values should be saved}

\item{higherOrderSummaryFunction}{A functon indicating the higher order
summary function (default is standard deviation `sd`)}

\item{parallel}{A logical input indicating whether to run
the permutation test using multiple cores in parallel.}

\item{BPPARAM}{A \code{BiocParallelParam} class object from
the \code{BiocParallel} package is used. Default is SerialParam().}

\item{usenperm_estimate}{Logical (default FALSE) if number of neighbouring
permutations should be used to estimate P-values, or
if difference of global higher order statistic should be used}

\item{nperm_estimate}{Number of neighbouring permutations to
use for p-value estimation}

\item{maxDist}{max difference of global higher order statistic to
use for p-value estimation (default 0.1)}

\item{plot}{A logical input indicating whether the results are plotted}

\item{verbose}{A logical input indicating whether the intermediate
steps will be printed}

\item{...}{parameters for function trajectoryWeightMatrix or spatialWeightMatrix}
}
\value{
A scHOT object
}
\description{
A wrapper function to perform scHOT
}
\examples{
data(MOB_subset)
sce_MOB_subset <- MOB_subset$sce_MOB_subset
scHOT_spatial <- scHOT_buildFromSCE(sce_MOB_subset,
                                    assayName = "logcounts",
                                    positionType = "spatial",
                                    positionColData = c("x", "y"))
pairs <- matrix(c("Arrb1", "Mtor", "Dnm1l", "Gucy1b3"), ncol = 2, byrow = TRUE)
rownames(pairs) <- apply(pairs,1,paste0,collapse = "_")

scHOT_spatial <- scHOT(scHOT_spatial,
                       testingScaffold = pairs,
                       positionType = "spatial",
                       positionColData = c("x", "y"),
                       nrow.out = NULL,
                       higherOrderFunction = weightedSpearman,
                       higherOrderFunctionType = "weighted",
                       numberPermutations = 100,
                       higherOrderSummaryFunction = sd,
                       parallel = FALSE,
                       verbose = TRUE,
                       span = 0.05)
}
