% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{pagoda.reduce.loading.redundancy}
\alias{pagoda.reduce.loading.redundancy}
\title{Collapse aspects driven by the same combinations of genes}
\usage{
pagoda.reduce.loading.redundancy(tam, pwpca, clpca = NULL, plot = FALSE,
  cluster.method = "complete", distance.threshold = 0.01, corr.power = 4,
  n.cores = detectCores(), abs = TRUE, ...)
}
\arguments{
\item{tam}{output of pagoda.top.aspects()}

\item{pwpca}{output of pagoda.pathway.wPCA()}

\item{clpca}{output of pagoda.gene.clusters() (optional)}

\item{plot}{whether to plot the resulting clustering}

\item{cluster.method}{one of the standard clustering methods to be used (fastcluster::hclust is used if available or stats::hclust)}

\item{distance.threshold}{similarity threshold for grouping interdependent aspects}

\item{corr.power}{power to which the product of loading and score correlation is raised}

\item{n.cores}{number of cores to use during processing}

\item{abs}{Boolean of whether to use absolute correlation}

\item{...}{additional arguments are passed to the pagoda.view.aspects() method during plotting}
}
\value{
a list structure analogous to that returned by pagoda.top.aspects(), but with addition of a $cnam element containing a list of aspects summarized by each row of the new (reduced) $xv and $xvw
}
\description{
Examines PC loading vectors underlying the identified aspects and clusters aspects based
on a product of loading and score correlation (raised to corr.power). Clusters of aspects
driven by the same genes are determined based on the distance.threshold and collapsed.
}
\examples{
data(pollen)
cd <- clean.counts(pollen)
\donttest{
knn <- knn.error.models(cd, k=ncol(cd)/4, n.cores=10, min.count.threshold=2, min.nonfailed=5, max.model.plots=10)
varinfo <- pagoda.varnorm(knn, counts = cd, trim = 3/ncol(cd), max.adj.var = 5, n.cores = 1, plot = FALSE)
pwpca <- pagoda.pathway.wPCA(varinfo, go.env, n.components=1, n.cores=10, n.internal.shuffles=50)
tam <- pagoda.top.aspects(pwpca, return.table = TRUE, plot=FALSE, z.score=1.96)  # top aspects based on GO only
tamr <- pagoda.reduce.loading.redundancy(tam, pwpca)
}

}

