% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{pagoda.subtract.aspect}
\alias{pagoda.subtract.aspect}
\title{Control for a particular aspect of expression heterogeneity in a given population}
\usage{
pagoda.subtract.aspect(varinfo, aspect, center = TRUE)
}
\arguments{
\item{varinfo}{normalized variance info (from pagoda.varnorm())}

\item{aspect}{a vector giving a cell-to-cell variation pattern that should be controlled for (length should be corresponding to ncol(varinfo$mat))}

\item{center}{whether the matrix should be re-centered following pattern subtraction}
}
\value{
a modified varinfo object with adjusted expression matrix (varinfo$mat)
}
\description{
Similar to subtracting n-th principal component, the current procedure determines
(weighted) projection of the expression matrix onto a specified aspect (some pattern
across cells, for instance sequencing depth, or PC corresponding to an undesired process
such as ribosomal pathway variation) and subtracts it from the data so that it is controlled
for in the subsequent weighted PCA analysis.
}
\examples{
data(pollen)
cd <- clean.counts(pollen)
\donttest{
knn <- knn.error.models(cd, k=ncol(cd)/4, n.cores=10, min.count.threshold=2, min.nonfailed=5, max.model.plots=10)
varinfo <- pagoda.varnorm(knn, counts = cd, trim = 3/ncol(cd), max.adj.var = 5, n.cores = 1, plot = FALSE)
# create go environment
library(org.Hs.eg.db)
# translate gene names to ids
ids <- unlist(lapply(mget(rownames(cd), org.Hs.egALIAS2EG, ifnotfound = NA), function(x) x[1]))
rids <- names(ids); names(rids) <- ids
go.env <- lapply(mget(ls(org.Hs.egGO2ALLEGS), org.Hs.egGO2ALLEGS), function(x) as.character(na.omit(rids[x])))
# clean GOs
go.env <- clean.gos(go.env)
# convert to an environment
go.env <- list2env(go.env)
# subtract the pattern
cc.pattern <- pagoda.show.pathways(ls(go.env)[1:2], varinfo, go.env, show.cell.dendrogram = TRUE, showRowLabels = TRUE)  # Look at pattern from 2 GO annotations
varinfo.cc <- pagoda.subtract.aspect(varinfo, cc.pattern)
}

}

