% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{scde.expression.magnitude}
\alias{scde.expression.magnitude}
\title{Return scaled expression magnitude estimates}
\usage{
scde.expression.magnitude(models, counts)
}
\arguments{
\item{models}{models determined by \code{\link{scde.error.models}}}

\item{counts}{count matrix}
}
\value{
a matrix of expression magnitudes on a log scale (rows - genes, columns - cells)
}
\description{
Return point estimates of expression magnitudes of each gene across a set of cells, based on the regression slopes determined during the model fitting procedure.
}
\examples{
data(es.mef.small)
cd <- clean.counts(es.mef.small, min.lib.size=1000, min.reads = 1, min.detected = 1)
data(o.ifm)  # Load precomputed model. Use ?scde.error.models to see how o.ifm was generated
# get expression magnitude estimates
lfpm <- scde.expression.magnitude(o.ifm, cd)

}

