% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{scde.failure.probability}
\alias{scde.failure.probability}
\title{Calculate drop-out probabilities given a set of counts or expression magnitudes}
\usage{
scde.failure.probability(models, magnitudes = NULL, counts = NULL)
}
\arguments{
\item{models}{models determined by \code{\link{scde.error.models}}}

\item{magnitudes}{a vector (\code{length(counts) == nrows(models)}) or a matrix (columns correspond to cells) of expression magnitudes, given on a log scale}

\item{counts}{a vector (\code{length(counts) == nrows(models)}) or a matrix (columns correspond to cells) of read counts from which the expression magnitude should be estimated}
}
\value{
a vector or a matrix of drop-out probabilities
}
\description{
Returns estimated drop-out probability for each cell (row of \code{models} matrix), given either an expression magnitude
}
\examples{
data(es.mef.small)
cd <- clean.counts(es.mef.small, min.lib.size=1000, min.reads = 1, min.detected = 1)
data(o.ifm)  # Load precomputed model. Use ?scde.error.models to see how o.ifm was generated
o.prior <- scde.expression.prior(models = o.ifm, counts = cd, length.out = 400, show.plot = FALSE)
# calculate probability of observing a drop out at a given set of magnitudes in different cells
mags <- c(1.0, 1.5, 2.0)
p <- scde.failure.probability(o.ifm, magnitudes = mags)
# calculate probability of observing the dropout at a magnitude corresponding to the
# number of reads actually observed in each cell
self.p <- scde.failure.probability(o.ifm, counts = cd)

}

