% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/numtS.R
\name{numtDetect_known}
\alias{numtDetect_known}
\title{Detecting nuclear mitochondria fusion events from known NUMT sites.}
\usage{
numtDetect_known(gr, numtS, max_ins_dist = 10, maxgap_numtS = 10)
}
\arguments{
\item{gr}{A GRanges object}

\item{numtS}{A GRanges object of known NUMT sites.}

\item{max_ins_dist}{The maximum distance allowed on the reference genome between the paired insertion sites.
Only intra-chromosomal NUMT events are supported. Default value is 10.}

\item{maxgap_numtS}{The maximum distance allowed betweeen the insertion sequence loci and known NUMTs.}
}
\value{
A nested list of GRanges objects of candidate NUMTs.
}
\description{
Detecting nuclear mitochondria fusion events from known NUMT sites.
}
\details{
This function looks for NUMTs which the insertion MT sequences come from known NUMT sites.
}
\keyword{internal}
