
\name{hgu95av2_dbconn}

\alias{hgu95av2_dbconn}
\alias{hgu95av2_dbfile}
\alias{hgu95av2_dbschema}
\alias{hgu95av2_dbInfo}


\title{Collect information about the package annotation DB}

\description{
  Some convenience functions for getting a connection object to (or collecting
  information about) the package annotation DB.
}

\usage{
  hgu95av2_dbconn()
  hgu95av2_dbfile()
  hgu95av2_dbschema(file="", show.indices=FALSE)
  hgu95av2_dbInfo()
}

\arguments{
  \item{file}{
    A connection, or a character string naming the file to print to (see
    the \code{file} argument of the \code{\link[base]{cat}} function for
    the details).
  }
  \item{show.indices}{
    The CREATE INDEX statements are not shown by default.
    Use \code{show.indices=TRUE} to get them.
  }
}

\details{
  \code{hgu95av2_dbconn} returns a connection object to the
  package annotation DB.  IMPORTANT: Don't call
  \code{\link[DBI:dbConnect]{dbDisconnect}} on the connection object
  returned by \code{hgu95av2_dbconn} or you will break all the
  \code{\link[AnnotationDbi:AnnDbObj-class]{AnnDbObj}} objects defined
  in this package!

  \code{hgu95av2_dbfile} returns the path (character string) to the
  package annotation DB (this is an SQLite file).

  \code{hgu95av2_dbschema} prints the schema definition of the
  package annotation DB.

  \code{hgu95av2_dbInfo} prints other information about the package
  annotation DB.
}

\value{
  \code{hgu95av2_dbconn}: a DBIConnection object representing an
  open connection to the package annotation DB.

  \code{hgu95av2_dbfile}: a character string with the path to the
  package annotation DB.

  \code{hgu95av2_dbschema}: none (invisible \code{NULL}).

  \code{hgu95av2_dbInfo}: none (invisible \code{NULL}).
}

\seealso{
  \code{\link[DBI:dbSendQuery]{dbGetQuery}},
  \code{\link[DBI:dbConnect]{dbConnect}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbconn}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbfile}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbschema}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbInfo}}
}

\examples{
  library(DBI)
  ## Count the number of rows in the "probes" table:
  dbGetQuery(hgu95av2_dbconn(), "SELECT COUNT(*) FROM probes")

  hgu95av2_dbschema()

  hgu95av2_dbInfo()
}

\keyword{utilities}
\keyword{datasets}

