## ----setup, include=FALSE-----------------------------------------------------
knitr::opts_chunk$set(echo = TRUE)

## -----------------------------------------------------------------------------
# Load expression matrix and metadata
library(ExperimentHub)
eh = ExperimentHub()
eh_query = query(eh, c("multiWGCNAdata"))

## download the autism data and metadata
autism_se = eh_query[["EH8219"]]

## -----------------------------------------------------------------------------
# Load multiWGCNA R package
library(multiWGCNA)

# Obtain metadata
sampleTable = colData(autism_se)

# Randomly sample 2000 genes from the expression matrix
set.seed(1)
autism_se = autism_se[sample(rownames(autism_se), 2000),]

# Check the data
assays(autism_se)[[1]][1:5, 1:5]
sampleTable

# Set the alpha level for statistical analyses and the soft power for network construction
alphaLevel = 0.05
softPower = 10

# If your sample traits include numbers that you'd like to be considered numerical 
# variables rather than categorical variables, set detectNumbers = TRUE
detectNumbers = FALSE

## ----eval = FALSE-------------------------------------------------------------
#  # Define our conditions for trait 1 (disease) and 2 (brain region)
#  conditions1 = unique(sampleTable[,2])
#  conditions2 = unique(sampleTable[,3])
#  # Construct the combined networks and all the sub-networks (autism only, controls only, FC only, and TC only)
#  # Same parameters as Tommasini and Fogel. BMC Bioinformatics
#  myNetworks = constructNetworks(autism_se, sampleTable, conditions1, conditions2,
#                                    networkType = "signed", TOMType = "unsigned",
#                                    power = softPower, minModuleSize = 100, maxBlockSize = 25000,
#                                    reassignThreshold = 0, minKMEtoStay = 0, mergeCutHeight = 0,
#                                    numericLabels = TRUE, pamRespectsDendro = FALSE,
#                                    deepSplit = 4, verbose = 3)

## -----------------------------------------------------------------------------
sessionInfo()

