## ----style, results = 'asis'--------------------------------------------------
BiocStyle::markdown()
knitr::opts_chunk$set(fig.wide = TRUE, fig.retina = 3, error=FALSE, eval=TRUE)

## ----rawDiagLogo, out.width="50%", fig.cap="The octopussy `rawDiag` package logo by Lilly van de Venn."----
knitr::include_graphics("octopussy.png")

## ----monoVersion--------------------------------------------------------------
if (Sys.info()["sysname"] %in% c("Darwin", "Linux")) {
  system2("mono", args = '--version', stdout = TRUE)
}

## ----installRawrr, eval=FALSE-------------------------------------------------
#  if (!require("BiocManager", quietly = TRUE))
#      install.packages("BiocManager")
#  
#  BiocManager::install("rawrr")

## ----checkInstallRequirements-------------------------------------------------
rawDiag::checkRawrr
rawDiag::checkRawrr()

if (isFALSE(rawrr::.checkDllInMonoPath())){
  rawrr::installRawFileReaderDLLs()
}
rawrr::installRawrrExe()

## ----listrawrrAssemblyPath----------------------------------------------------
rawrr::rawrrAssemblyPath()
rawrr::rawrrAssemblyPath() |> list.files()

## ----fetchFromExperimentHub---------------------------------------------------
library(ExperimentHub)
ExperimentHub::ExperimentHub() -> eh
normalizePath(eh[["EH3222"]]) -> EH3222
normalizePath(eh[["EH4547"]]) -> EH4547

(rawfileEH3222 <- paste0(EH3222, ".raw"))
if (!file.exists(rawfileEH3222)){
  file.copy(EH3222, rawfileEH3222)
}

(rawfileEH4547 <- paste0(EH4547, ".raw"))
if (!file.exists(rawfileEH4547)){
  file.copy(EH4547, rawfileEH4547)
}

c(rawfileEH3222, rawfileEH4547) -> rawfile

## ----header-------------------------------------------------------------------
(rawfile |>
  lapply(FUN = rawrr::readFileHeader) -> rawFileHeader)

## ----readEH4547OrbitrapTrailerTable-------------------------------------------
rawfile |>
  lapply(FUN = rawDiag::readRaw) |>
  Reduce(f = rbind) -> x
  #BiocParallel::bplapply(FUN = rawDiag::readRaw) |>

## ----listFUN------------------------------------------------------------------
library(rawDiag)
ls("package:rawDiag") |>
  grep(pattern = '^plot', value = TRUE) -> pm

pm |>
  knitr::kable(col.names = "package:rawDiag plot functions")

## ----plotALL, fig.width = 10, fig.height = 5----------------------------------
pm |> 
  lapply(FUN = function(plotFUN) {
    lapply(c('trellis'), function(method) {
      message("plotting", plotFUN, "using method", method, "...")
      do.call(plotFUN, list(x, method)) 
    })
  }) 

## ----shinyApp-----------------------------------------------------------------
rawfile |>
  dirname() |>
  rawDiag::buildRawDiagShinyApp() -> app

## ----runApp, eval=FALSE-------------------------------------------------------
#  shiny::runApp(app)

## ----FAQ1, eval=FALSE---------------------------------------------------------
#  file.path(Sys.getenv("HOME"), "Downloads") |>
#    setwd()
#  
#  list.files() |>
#    grep(pattern = '*.raw$', value = TRUE) |>
#    lapply(FUN = rawDiag::readRaw) |>
#    Reduce(f = rbind) -> x

## ----sessioninfo, eval=TRUE---------------------------------------------------
sessionInfo()

