% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/samplesMetricMap.R
\name{samplesMetricMap}
\alias{samplesMetricMap}
\alias{samplesMetricMap,list-method}
\alias{samplesMetricMap,matrix-method}
\alias{samplesMetricMap,ClassifyResult-method}
\title{Plot a Grid of Sample-wise Predictive Metrics}
\usage{
\S4method{samplesMetricMap}{ClassifyResult}(results, ...)

\S4method{samplesMetricMap}{list}(
  results,
  comparison = "auto",
  metric = "auto",
  featureValues = NULL,
  featureName = NULL,
  metricColours = list(c("#FFFFFF", "#CFD1F2", "#9FA3E5", "#6F75D8", "#3F48CC"),
    c("#FFFFFF", "#E1BFC4", "#C37F8A", "#A53F4F", "#880015")),
  classColours = c("#3F48CC", "#880015"),
  groupColours = c("darkgreen", "yellow2"),
  fontSizes = c(24, 16, 12, 12, 12),
  mapHeight = 4,
  title = "auto",
  showLegends = TRUE,
  xAxisLabel = "Sample Name",
  showXtickLabels = TRUE,
  yAxisLabel = "Analysis",
  showYtickLabels = TRUE,
  legendSize = grid::unit(1, "lines")
)

\S4method{samplesMetricMap}{matrix}(
  results,
  classes,
  metric = c("Sample Error", "Sample Accuracy"),
  featureValues = NULL,
  featureName = NULL,
  metricColours = list(c("#3F48CC", "#6F75D8", "#9FA3E5", "#CFD1F2", "#FFFFFF"),
    c("#880015", "#A53F4F", "#C37F8A", "#E1BFC4", "#FFFFFF")),
  classColours = c("#3F48CC", "#880015"),
  groupColours = c("darkgreen", "yellow2"),
  fontSizes = c(24, 16, 12, 12, 12),
  mapHeight = 4,
  title = "Error Comparison",
  showLegends = TRUE,
  xAxisLabel = "Sample Name",
  showXtickLabels = TRUE,
  yAxisLabel = "Analysis",
  showYtickLabels = TRUE,
  legendSize = grid::unit(1, "lines")
)
}
\arguments{
\item{results}{A list of \code{\link{ClassifyResult}} objects. Could also be
a matrix of pre-calculated metrics, for backwards compatibility.}

\item{...}{Parameters not used by the \code{ClassifyResult} method that does
list-packaging but used by the main \code{list} method.}

\item{comparison}{Default: \code{"auto"}. The aspect of the experimental
design to compare. Can be any characteristic that all results share.}

\item{metric}{Default: \code{"auto"}. The name of the
performance measure or "auto". If the results are classification then
sample accuracy will be displayed. Otherwise, the results would be survival risk
predictions and then a sample C-index will be displayed. Valid values are \code{"Sample Error"},
\code{"Sample Error"} or \code{"Sample C-index"}. If the metric is not stored in the
results list, the performance metric will be calculated automatically.}

\item{featureValues}{If not NULL, can be a named factor or named numeric
vector specifying some variable of interest to plot above the heatmap.}

\item{featureName}{A label describing the information in
\code{featureValues}. It must be specified if \code{featureValues} is.}

\item{metricColours}{If the outcome is categorical, a list of vectors of colours
for metric levels for each class. If the outcome is numeric, such as a risk score,
then a single vector of colours for the metric levels for all samples.}

\item{classColours}{Either a vector of colours for class levels if both
classes should have same colour, or a list of length 2, with each component
being a vector of the same length. The vector has the colour gradient for
each class.}

\item{groupColours}{A vector of colours for group levels. Only useful if
\code{featureValues} is not NULL.}

\item{fontSizes}{A vector of length 5. The first number is the size of the
title.  The second number is the size of the axes titles. The third number
is the size of the axes values. The fourth number is the size of the
legends' titles. The fifth number is the font size of the legend labels.}

\item{mapHeight}{Height of the map, relative to the height of the class
colour bar.}

\item{title}{The title to place above the plot.}

\item{showLegends}{Logical. IF FALSE, the legend is not drawn.}

\item{xAxisLabel}{The name plotted for the x-axis. NULL suppresses label.}

\item{showXtickLabels}{Logical. IF FALSE, the x-axis labels are hidden.}

\item{yAxisLabel}{The name plotted for the y-axis. NULL suppresses label.}

\item{showYtickLabels}{Logical. IF FALSE, the y-axis labels are hidden.}

\item{legendSize}{The size of the boxes in the legends.}

\item{classes}{If \code{results} is a matrix, this is a factor vector of the
same length as the number of columns that \code{results} has.}
}
\value{
A grob is returned that can be drawn on a graphics device.
}
\description{
A grid of coloured tiles is drawn. There is one column for each sample and
one row for each cross-validation result.
}
\details{
The names of \code{results} determine the row names that will be in the
plot. The length of \code{metricColours} determines how many bins the metric
values will be discretised to.
}
\examples{

  predicted <- DataFrame(sample = LETTERS[sample(10, 100, replace = TRUE)],
                          class = rep(c("Healthy", "Cancer"), each = 50))
  actual <- factor(rep(c("Healthy", "Cancer"), each = 5), levels = c("Healthy", "Cancer"))
  features <- sapply(1:100, function(index) paste(sample(LETTERS, 3), collapse = ''))
  result1 <- ClassifyResult(DataFrame(characteristic = c("Data Set", "Selection Name", "Classifier Name",
                                                         "Cross-validation"),
                            value = c("Example", "t-test", "Differential Expression", "2 Permutations, 2 Folds")),
                            LETTERS[1:10], features, list(1:100), list(sample(10, 10)),
                            list(function(oracle){}), NULL, predicted, actual)
  predicted[, "class"] <- sample(predicted[, "class"])
  result2 <- ClassifyResult(DataFrame(characteristic = c("Data Set", "Selection Name", "Classifier Name",
                                                         "Cross-validation"),
                            value = c("Example", "Bartlett Test", "Differential Variability", "2 Permutations, 2 Folds")),
                            LETTERS[1:10], features, list(1:100), list(sample(10, 10)),
                            list(function(oracle){}), NULL, predicted, actual)
  result1 <- calcCVperformance(result1)
  result2 <- calcCVperformance(result2)
  groups <- factor(rep(c("Male", "Female"), length.out = 10))
  names(groups) <- LETTERS[1:10]
  cholesterol <- c(4.0, 5.5, 3.9, 4.9, 5.7, 7.1, 7.9, 8.0, 8.5, 7.2)
  names(cholesterol) <- LETTERS[1:10]
  
  wholePlot <- samplesMetricMap(list(Gene = result1, Protein = result2))
  wholePlot <- samplesMetricMap(list(Gene = result1, Protein = result2),
                                featureValues = groups, featureName = "Gender")
  wholePlot <- samplesMetricMap(list(Gene = result1, Protein = result2),
                                featureValues = cholesterol, featureName = "Cholesterol")                                

}
\author{
Dario Strbenac
}
